/**
 * CSVI VirtueMart JavaScript
 *
 * CSVI VirtueMart
 * Copyright (C) 2006 - 2011 RolandD Cyber Produksi
 *
 * @package CSVI VirtueMart
 * @version $Id: csvivirtuemart.js 1549 2011-03-16 07:56:44Z RolandD $
 */

var _timeout = null;
var notallowedkeys = [9, 10, 16, 17, 18, 20, 27, 37, 38, 39, 40, 92, 93];
jQuery("#searchuser").live('keyup', function(e) {
	if (jQuery.inArray(e.keyCode, notallowedkeys) >= 0) {
		return;
	}
	else {
		if(_timeout != null) { 
			clearTimeout(_timeout); _timeout = null; 
		} 
		_timeout = setTimeout('searchUser()', 1000);
	}
})

function searchUser() {
	_timeout = null;
	jQuery("#selectuserid tbody").remove();
	jQuery("#selectuserid").append('<tbody><tr><td colspan="2"><div id="ajaxuserloading"><img src="/administrator/components/com_csvivirtuemart/assets/images/ajax-loading.gif" /></div></td></tr></tbody>');
	var searchfilter = jQuery("input[name='searchuserbox']").val();
	jQuery.getJSON("index.php",{option: 'com_csvivirtuemart', controller: 'export', task: 'getuser',  format: 'json', filter: searchfilter}, function(data){
		jQuery("#ajaxuserloading").remove();
		jQuery("#selectuserid tbody").remove();
		var options = [];
		var r = 0;
		options[++r] = '<tbody>';
		if (data.length > 0) {
			for (var i = 0; i < data.length; i++) {
				options[++r] = '<tr><td class="user_id">';
				options[++r] = data[i].user_id;
				options[++r] = '</td><td class="user_name">';
				options[++r] = data[i].user_name;
				options[++r] = '</td></tr>';
			}
		}
		options[++r] = '</tbody>';
		jQuery("#selectuserid").append(options.join(''));
		jQuery("table#selectuserid tr:even").addClass("row0");
		jQuery("table#selectuserid tr:odd").addClass("row1");
		jQuery('table#selectuserid tbody tr').click(function() {
			var user_id = jQuery(this).find('td.user_id').html();
			/* Check if the user ID is already in the select box */
			var existingvals = jQuery("select#jformorderorderuser").val();
			if (jQuery.inArray(user_id, existingvals) >= 0) {
				return;
			}
			else {
				var options = '<option value="'+user_id+'" selected="selected">'+jQuery(this).find('td.user_name').html()+'</option>';
				jQuery("select#jformorderorderuser").append(options);
				jQuery("select#jformorderorderuser option:eq(0)").attr("selected", "");
			}
		});
	})
}

jQuery("#searchproduct").live('keyup', function(e) {
	if (jQuery.inArray(e.keyCode, notallowedkeys) >= 0) {
		return;
	}
	else {
		if(_timeout != null) { 
			clearTimeout(_timeout); _timeout = null; 
		} 
		_timeout = setTimeout('searchProduct()', 1000);
	}
})

function searchProduct() {
	_timeout = null;
	jQuery("#selectproductsku tbody").remove();
	jQuery("#selectproductsku").append('<tbody><tr><td colspan="2"><div id="ajaxproductloading"><img src="/administrator/components/com_csvivirtuemart/assets/images/ajax-loading.gif" /></div></td></tr></tbody>');
	var searchfilter = jQuery("input[name='searchproductbox']").val();
	jQuery.getJSON("index.php",{option: 'com_csvivirtuemart', controller: 'export', task: 'getproduct',  format: 'json', filter: searchfilter}, function(data){
		jQuery("#ajaxproductloading").remove();
		jQuery("#selectproductsku tbody").remove();
		var options = [];
		var r = 0;
		options[++r] = '<tbody>';
		if (data.length > 0) {
			for (var i = 0; i < data.length; i++) {
				options[++r] = '<tr><td class="product_sku">';
				options[++r] = data[i].product_sku;
				options[++r] = '</td><td class="product_name">';
				options[++r] = data[i].product_name;
				options[++r] = '</td></tr>';
			}
		}
		options[++r] = '</tbody>';
		jQuery("#selectproductsku").append(options.join(''));
		jQuery("table#selectproductsku tr:even").addClass("row0");
		jQuery("table#selectproductsku tr:odd").addClass("row1");
		jQuery('table#selectproductsku tbody tr').click(function() {
			var product_sku = jQuery(this).find('td.product_sku').html();
			/* Check if the product ID is already in the select box */
			var existingvals = jQuery("select#jformorderorderproduct").val();
			if (jQuery.inArray(product_sku, existingvals) >= 0) {
				return;
			}
			else {
				var options = '<option value="'+product_sku+'" selected="selected">'+jQuery(this).find('td.product_name').html()+'</option>';
				jQuery("select#jformorderorderproduct").append(options);
				jQuery("select#jformorderorderproduct option:eq(0)").attr("selected", "");
			}
		});
	})
}

jQuery("#searchitemproduct").live('keyup', function(e) {
	if (jQuery.inArray(e.keyCode, notallowedkeys) >= 0) {
		return;
	}
	else {
		if(_timeout != null) { 
			clearTimeout(_timeout); _timeout = null; 
		} 
		_timeout = setTimeout('searchItemProduct()', 1000);
	}
})

function searchItemProduct() {
	_timeout = null;
	jQuery("#selectitemproductsku tbody").remove();
	jQuery("#selectitemproductsku").append('<tbody><tr><td colspan="2"><div id="ajaxproductloading"><img src="/administrator/components/com_csvivirtuemart/assets/images/ajax-loading.gif" /></div></td></tr></tbody>');
	var searchfilter = jQuery("input[name='searchitemproductbox']").val();
	jQuery.getJSON("index.php",{option: 'com_csvivirtuemart', controller: 'export', task: 'getitemproduct',  format: 'json', filter: searchfilter}, function(data){
		jQuery("#ajaxproductloading").remove();
		jQuery("#selectitemproductsku tbody").remove();
		var options = [];
		var r = 0;
		options[++r] = '<tbody>';
		if (data.length > 0) {
			for (var i = 0; i < data.length; i++) {
				options[++r] = '<tr><td class="product_sku">';
				options[++r] = data[i].product_sku;
				options[++r] = '</td><td class="product_name">';
				options[++r] = data[i].product_name;
				options[++r] = '</td></tr>';
			}
		}
		options[++r] = '</tbody>';
		jQuery("#selectitemproductsku").append(options.join(''));
		jQuery("table#selectitemproductsku tr:even").addClass("row0");
		jQuery("table#selectitemproductsku tr:odd").addClass("row1");
		jQuery('table#selectitemproductsku tbody tr').click(function() {
			var product_sku = jQuery(this).find('td.product_sku').html();
			/* Check if the product ID is already in the select box */
			var existingvals = jQuery("select#jformorderitemorderitemproduct").val();
			if (jQuery.inArray(product_sku, existingvals) >= 0) {
				return;
			}
			else {
				var options = '<option value="'+product_sku+'" selected="selected">'+jQuery(this).find('td.product_name').html()+'</option>';
				jQuery("select#jformorderitemorderitemproduct").append(options);
				jQuery("select#jformorderitemorderitemproduct option:eq(0)").attr("selected", "");
			}
		});
	})
}

/**
 * Updates the classes on a table
 */
function UpdateRowClass(table) {
	jQuery("table#"+table+" tr:even").addClass("row0");
	jQuery("table#"+table+" tr:odd").addClass("row1");
}

jQuery(function() {
	jQuery('#toolbar-help span').removeClass('icon-32-help');
	jQuery('#toolbar-help span').addClass('icon-32-csvivirtuemart_help_32');
});

/**
 * Set the maintenance task
 */
function setTask(task) {
	 document.adminForm.task.value = task;
}
