<?php
/**
 * Export controller
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: export.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.controller');

/**
 * Export Controller
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartControllerExport extends JController {
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function __construct() {
		parent::__construct();
		
		$this->registerTask('getUser','getData');
		$this->registerTask('getProduct','getData');
		$this->registerTask('getItemProduct','getData');
		$this->registerTask('loadfields','getData');
		$this->registerTask('loadtables','getData');
		$this->registerTask('loadsites','getData');
		
		$this->registerTask('load','export');
		$this->registerTask('saveasnew','save');
	}	
	
	/**
	 * Show the export option screen 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return
	 * @since 		3.0
	 */
	public function Export() {
		// Create the view object
		$view = $this->getView('export', JRequest::getVar('format', 'html'));
		
		// Standard model
		$view->setModel( $this->getModel( 'export', 'CsvivirtuemartModel' ), true );
		$view->setModel( $this->getModel( 'templates', 'CsvivirtuemartModel' ));
		$view->setModel( $this->getModel( 'availablefields', 'CsvivirtuemartModel' ));
		
		// Now display the view
		$view->display();
	}
	
	/**
	 * Retrieve different kinds of data in JSON format 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getData() {
		// Create the view object
		$view = $this->getView('export', 'json');
		
		// Standard model
		$view->setModel( $this->getModel( 'export', 'CsvivirtuemartModel' ), true );
		$view->setModel( $this->getModel( 'availablefields', 'CsvivirtuemartModel' ));
		$view->setLayout('export');
		
		// Now display the view
		$view->display();
	}
	
	/**
	 * Save export settings  
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function save() {
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$model = $this->getModel('templates');
		
		// Store the form fields
		$app	= JFactory::getApplication();
		$data	= JRequest::getVar('jform', array(), 'post', 'array');
		
		// Re-order the export fields
		// Process field
		$fields = array();
		foreach ($data['export_fields']['_process_field'] as $field) {
			$fields[] = $field;
		}
		$data['export_fields']['_process_field'] = $fields;
		
		// Combine field
		$fields = array();
		foreach ($data['export_fields']['_combine_field'] as $field) {
			$fields[] = $field;
		}
		$data['export_fields']['_combine_field'] = $fields;
		
		// Sort field
		$fields = array();
		foreach ($data['export_fields']['_sort_field'] as $field) {
			$fields[] = $field;
		}
		$data['export_fields']['_sort_field'] = $fields;
		
		// Re-order the replacement fields
		$fields = array();
		foreach ($data['replacement_export_fields']['_replace_type'] as $field) {
			$fields[] = $field;
		}
		$data['replacement_export_fields']['_replace_type'] = $fields;
		
		// Save the data
		$id = $model->save($data, 'export');
		
		// Redirect back to the export page
		$this->setRedirect(JRoute::_('index.php?option=com_csvivirtuemart&view=export&task=export&template_id='.$id, false));
	}
	
	/**
	 * Remove an export template  
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function remove() {
		// Check for request forgeries
		JRequest::checkToken() or jexit( 'Invalid Token' );
		$model = $this->getModel('templates');
		
		// Save the data
		$model->remove('export');
		
		// Redirect back to the export page
		$this->setRedirect(JRoute::_('index.php?option=com_csvivirtuemart&view=export&task=export', false));
	}
}
?>
