<?php
/**
 * Export controller
 *
 * @package 	CSVIVirtueMart
 * @author	 	Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: exportfile.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.controller');

/**
 * Export Controller
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartControllerExportfile extends JController {
	
	/**
	 * Load export model files
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function exportFile() {
		// Create the view object
		$view = $this->getView('exportfile', 'html');
		$option = JRequest::getVar('option');
		
		// Default model
		$view->setModel( $this->getModel('exportfile', 'CsvivirtuemartModel' ), true );
		// Log functions
		$view->setModel( $this->getModel('log', 'CsvivirtuemartModel' ));
		// Settings functions
		$view->setModel( $this->getModel('settings', 'CsvivirtuemartModel' ));
		// General import functions
		$view->setModel( $this->getModel('export', 'CsvivirtuemartModel' ));
		// General category functions
		$view->setModel( $this->getModel('category', 'CsvivirtuemartModel' ));
		// Available fields
		$view->setModel( $this->getModel('availablefields', 'CsvivirtuemartModel' ));
		
		// Load the model
		$model = $this->getModel('exportfile');
		
		// Add extra helper paths
		$view->addHelperPath(JPATH_COMPONENT_ADMINISTRATOR.'/helpers/xml');
		$view->addHelperPath(JPATH_COMPONENT_ADMINISTRATOR.'/helpers/html');
		
		// Load the helper classes
		$view->loadHelper('csvidb');
		$view->loadHelper('vm_config');
		$view->loadHelper('template');
		
		// Prepare for export
		if ($model->getPrepareExport()) {
			
			// Set the export override
			$app = JFactory::getApplication();
			$template = JRequest::getVar('template');
			$overridefile = JPATH_BASE.'/templates/'.$app->getTemplate().'/html/'.$option.'/models/export/'.$template->getValue('export_type').'.php';
			
			// Add the import model path if override exists
			if (file_exists($overridefile)) $this->addModelPath(JPATH_BASE.'/templates/'.$app->getTemplate().'/html/'.$option.'/models/export');
			else $this->addModelPath(JPATH_COMPONENT_ADMINISTRATOR.'/models/export');
			
			// Set the layout
			if (JRequest::getBool('cron', false)) $view->setLayout('cron');
		
			// Start the export
			$view->display();
		}
		else {
			// Clean up first
			$model->getCleanSession();
			// Redirect back to the export page
			$this->setRedirect('index.php?option='.JRequest::getVar('option').'&task=export&view=export', JText::_('COM_CSVIVIRTUEMART_ERROR_EXPORT_PREP'), 'error');
		}
	}	
}
?>