<?php
/**
 * Log controller
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: log.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport('joomla.application.component.controller');

/**
 * Log Controller
 *
 * @package    CSVIVirtueMart
 */
class CsvivirtuemartControllerLog extends JController {
	
	/**
	 * Constructor 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function __construct() {
		parent::__construct();
		
		// Redirects
		$this->registerTask('remove_all','remove');
	}
	
	/**
	 * List the log files 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function log() {
		JRequest::setVar('view', 'log');
		
		parent::display();
	}
	
	/**
	 * Cancel the operation 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.5
	 */
	public function cancel() {
		$this->setRedirect('index.php?option=com_csvivirtuemart&view=log');
	}
	
	/**
	 * Download a debug log file 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function downloadDebug() {
		$log = $this->getModel('log', 'CsvivirtuemartModel');
		$log->downloadDebug();
	}
	
	/**
	 * Read a logfile from disk and show it in a popup 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function LogReader() {
		JRequest::setVar('view', 'log');
		JRequest::setVar('layout', 'logreader');
		JRequest::setVar('hidemainmenu', 1);
		
		parent::display();
	}
	
	/**
	 * Delete log files 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function remove() {
		$model = $this->getModel('log');
		switch ($this->getTask()) {
			case 'remove':
				$results = $model->getDelete();
				break;
			case 'remove_all':
				$results = $model->getDeleteAll();
				break;
		}
		
		foreach ($results as $type => $messages) {
			foreach ($messages as $msg) {
				if ($type == 'ok') $this->setMessage($msg);
				else if ($type == 'nok') $this->setMessage($msg, 'error');
			}
		}
		$this->setRedirect('index.php?option='.JRequest::getCmd('option').'&view=log');
	}
}
?>
