<?php
/**
 * Admin interface
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @todo
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: csvivirtuemart.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

// Load the logger
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/log.php');

// Load the general helper
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/csvi.php');

// Get the database object
$db = JFactory::getDBO();

// Do some requirement checks
// Check to see if the user uses at least PHP 5
if (version_compare(phpversion(), '5', '<') == '-1') {
	$php5_message = JText::sprintf('COM_CSVIVIRTUEMART_NO_PHP5', phpversion());
	if (JRequest::getBool('cron')) echo $php5_message;
	else {
		echo '<img src="'.JURI::root().'administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_logo.png" alt="CSVI VirtueMart"/>';
		echo '<div><img src="'.JURI::root().'administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_help_32.png" alt="'.$php5_message.'" /> '.$php5_message.'</div>';
	}
}
else {
	// Define the tmp folder
	$config = JFactory::getConfig();
	$tmp_path = $config->getValue('config.tmp_path');
	if (!defined('CSVIPATH_TMP')) define('CSVIPATH_TMP', JPath::clean($tmp_path.'/com_csvivirtuemart', '/'));
	if (!defined('CSVIPATH_DEBUG')) define('CSVIPATH_DEBUG', JPath::clean($tmp_path.'/com_csvivirtuemart/debug', '/'));

	// Set the global settings
	require_once(JPATH_COMPONENT_ADMINISTRATOR.'/models/settings.php');
	$settings = new CsvivirtuemartModelSettings();
	$settings->getSettings();
	$hostname = $settings->getSetting('hostname');
	if (JRequest::getWord('view') !== 'settings' && empty($hostname)) JApplication::enqueueMessage(JText::_('COM_CSVIVIRTUEMART_NO_HOSTNAME_SET'), 'error');
	JRequest::setVar('settings', $settings);

    // Start preparing
    if (JRequest::getBool('cron', false)) {
		// Override preview in cron mode
		JRequest::setVar('was_preview', true);
    }
    else {
		// Not doing cron, so set it to false
		JRequest::setVar('cron', false);

		// Add stylesheets
		$document = JFactory::getDocument();
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/images.css');
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/display.css');
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/tables.css');
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/jquery.alerts.css');
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/jquery-ui.css');
		$document->addStyleSheet(JURI::root().'administrator/components/com_csvivirtuemart/assets/css/jquery-csvi.css');
		if (JRequest::getWord('format') != 'json') {
			?>
			<!--[if IE]>
			 	<link rel="stylesheet" href="<?php echo JURI::root() ?>/administrator/components/com_csvivirtuemart/assets/css/jquery-csvi-ie.css" type="text/css" />
			<![endif]-->
			<?php
		}
		// Add javascript
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery.js');
		$document->addScriptDeclaration('jQuery.noConflict();');
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery.alerts.js');
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery.timers.js');
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery-ui.js');
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery.tablednd_0_5.js');
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/csvivirtuemart.js');
		JHTML::_('behavior.modal');
    }

    // Require the base controller
    require_once (JPATH_COMPONENT.'/controller.php');

    // Require specific controller if requested
    $view = JRequest::getWord('view', 'csvivirtuemart');
    require_once (JPATH_COMPONENT.'/controllers/'.$view.'.php');

    // Create the controller
    $classname   = 'CsvivirtuemartController'.$view;
    $controller = new $classname();

    // Perform the Request task
    $task = JRequest::getWord('task', $view);
    $controller->execute(JRequest::getWord('task', $view));

    // Redirect if set by the controller
    $controller->redirect();
}
?>