<?php
/**
 * CSVI Form helper
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: template.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Helper class for templates
 * @package CSVIVirtueMart
 */
class CsviTemplate {

	/** @var object contains the form data */
	private $_template = array();

	/**
	 * Method Description
	 *
	 * @copyright
	 * @author
	 * @todo
	 * @see
	 * @access
	 * @param
	 * @return
	 * @since
	 */
	public function __construct($data) {
	 	 $this->_template = $data;
	}

    /**
     * Find a value in the template
     *
     * @copyright
     * @author 		RolandD
     * @todo
     * @see 		JFilterInput
     * @access 		public
     * @param 		string	$name		the name of the parameter to find
     * @param 		string	$group		the group in which to find the parameter
     * @param		string	$default	the default value to use when not found
     * @param		string	$filter		the filter to apply
     * @param 		int 	$mask		Filter bit mask. 1=no trim: If this flag is cleared and the
	 * 									input is a string, the string will have leading and trailing whitespace
	 * 									trimmed. 2=allow_raw: If set, no more filtering is performed, higher bits
	 * 									are ignored. 4=allow_html: HTML is allowed, but passed through a safe
	 * 									HTML filter first. If set, no more filtering is performed. If no bits
	 * 									other than the 1 bit is set, a strict filter is applied.
     * @return 		mixed	the value found
     * @since 		3.0
     */
    public function getValue($name, $group='', $default = '', $filter=null, $mask=0) {
    	// Set the initial value
    	$value = '';

    	// Find the value
    	if (empty($group)) {
			if (array_key_exists($name, $this->_template)) $value = $this->_template[$name];
    	}
    	else {
			if (array_key_exists($group, $this->_template)) {

				if (array_key_exists($name, $this->_template[$group])) {
					$value = $this->_template[$group][$name];
				}
			}
    	}

    	// Return the found value
    	if (is_array($value) && empty($value)) $value = $default;
    	else if ('' === $value) $value = $default;

    	// Clean up and return
    	if (is_null($filter) && $mask == 0) return $value;
    	else return JRequest::_cleanVar($value, $mask, $filter);
    }

    /**
     * Set a value in the template
     *
     * @copyright
     * @author 		RolandD
     * @todo
     * @see
     * @access 		public
     * @param 		string	$name		the name of the parameter to find
     * @param 		string	$group		the group in which to find the parameter
     * @param		string	$value		the value to set
     * @return 		void
     * @since 		3.0
     */
    public function setValue($name, $group='', $value = '') {
    	// Set the value
    	if (empty($group)) {
			$this->_template[$name] = $value;
    	}
    	else {
    		$this->_template[$group][$name] = $value;
    	}
    }
}
?>
