<?php
/**
 * VirtueMart config class
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: vm_config.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * The VirtueMart Config Class
 *
 * @package CSVIVirtueMart
 */
class CsviVmConfig {
	
	private $_vmcfgfile = null;
	private $_vmcfg = array();
	
	public function __construct() {
		$this->_vmcfgfile = JPATH_ADMINISTRATOR.'/components/com_virtuemart/virtuemart.cfg.php';
		$this->_vmcfg = file($this->_vmcfgfile);
	}
	
	/**
	* Finds a given VirtueMart setting
	* @var string $setting The config value to find
	* @return string the value of the config setting
	*/
	public function getSetting($setting) {
		$key = $this->array_find($setting, $this->_vmcfg);
		if ($key) {
			$find_setting = explode('\', \'', $this->_vmcfg[$key]);
			return substr(trim($find_setting[1]), 0, -3);
		}
		else return false;
	}
	
	/**
	* Searched the array for a partial value
	* @return mixed Array key if found otherwise false
	*/
	private function array_find($needle, $haystack) {
	   foreach ($haystack as $key => $item) {
		  if (stripos($item, $needle) !== FALSE) {
			 return $key;
			 break;
		  }
	   }
	   // Nothing found return false
	   return false;
	}
}
?>