<?php
/**
 * Cron model
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: cron.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Cron Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelCron extends JModel {

	/**
	 * Build the command to use for the cron command to do an import/export
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		string	the parameters for the cron line
	 * @since 		3.0
	 */
	public function getCronLine() {
		$db = JFactory::getDBO();
		$template = JRequest::getVar('template');
		$option = JRequest::getVar('option');
		$data = JRequest::getVar($option.'.data');
		$cronline = '';
		$notemplate = false;

		// Get the template used
		$template_id = JRequest::getInt('template_id', 0);
		if ($template_id) {
			$cronline .= ' template_id="'.$template_id.'"';

			// Load the template settings to compare against selection
			$q = "SELECT settings, type
				FROM #__csvivirtuemart_template_settings
				WHERE id = ".$template_id;
			$db->setQuery($q);
			$details = $db->loadObject();
			$settings = json_decode($details->settings, true);
		}
		else {
			$notemplate = true;
			// Initialise the details
			$details = new StdClass;
			if (array_key_exists('import_type', $data)) $details->type = 'import';
			else if (array_key_exists('export_type', $data)) $details->type = 'export';
			// Load the settings
			$settings = $data;
		}

		// Check if this is an import or export cron
		if ($details->type == 'export') {
			// General export options
			if ($notemplate) $general = $settings['general'];
			else $general = CsviHelper::recurseArrayDiff($template->getValue('general'), $settings['general']);
			foreach ($general as $name => $setting) {
				switch ($name) {
					case 'exportto':
						if (!empty($setting)) {
							if ($setting == 'todownload') $setting = 'tofile';
							$cronline .= ' jform:general:'.$name.'="'.$setting.'" ';
						}
						break;
					case 'localpath':
						if (!empty($setting)) {
							if ($template->getValue('exportto', 'general') == 'todownload' || $template->getValue('exportto', 'general') == 'tofile') {
								$cronline .= ' jform:general:'.$name.'="'.$setting.'" ';
							}
						}
						break;
					default:
						if (!empty($setting)) $cronline .= ' jform:general:'.$name.'="'.$setting.'" ';
						break;
				}
			}

			switch ($data['export_type']) {
				case 'productexport':
					if ($notemplate) $values = $settings['product'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('product'), $settings['product']);
					$cronline .= $this->_getCronSetting($values, 'product');
					break;
				case 'orderexport':
					if ($notemplate) $values = $settings['order'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('order'), $settings['order']);
					$cronline .= $this->_getCronSetting($values, 'order');
					break;
				case 'orderitemexport':
					if ($notemplate) $values = $settings['orderitem'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('orderitem'), $settings['orderitem']);
					$cronline .= $this->_getCronSetting($values, 'orderitem');
					break;
				case 'userinfoexport':
					if ($notemplate) $values = $settings['userinfo'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('userinfo'), $settings['userinfo']);
					$cronline .= $this->_getCronSetting($values, 'userinfo');
					break;
				case 'multiplepricesexport':
					if ($notemplate) $values = $settings['multipleprices'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('multipleprices'), $settings['multipleprices']);
					$cronline .= $this->_getCronSetting($values, 'multipleprices');
					break;
				case 'producttypenamesexport':
					if ($notemplate) $values = $settings['producttypename'];
					else $values = CsviHelper::recurseArrayDiff($template->getValue('producttypename'), $settings['producttypename']);
					$cronline .= $this->_getCronSetting($values, 'producttypename');
					break;
			}

			// Email settings
			if ($notemplate) $values = $settings['email'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('email'), $settings['email']);
			$cronline .= $this->_getCronSetting($values, 'email');

			// Export fields
			if ($notemplate) {
				if (array_key_exists('export_fields', $settings)) $fields = $settings['export_fields'];
				else $fields = array();
			}
			else $fields = $template->getValue('export_fields', '', array());
			if (!empty($fields)) {
				$fields['_selected_name'] = CsviHelper::recurseArrayDiff($fields['_selected_name'], $settings['export_fields']['_selected_name']);
				if (!empty($fields['_selected_name'])) {
					$cronline .= ' jform:export_fields:_selected_name = "'.implode('|', $template->getValue('_selected_name', 'export_fields')).'|"';
					$cronline .= ' jform:export_fields:_column_header = "'.implode('|', $template->getValue('_column_header', 'export_fields')).'|"';
					$cronline .= ' jform:export_fields:_default_value = "'.implode('|', $template->getValue('_default_value', 'export_fields')).'|"';
					$cronline .= ' jform:export_fields:_process_field = "'.implode('|', $template->getValue('_process_field', 'export_fields')).'|"';
				}
			}
		}
		else if ($details->type == 'import') {
			// General import options
			if ($notemplate) $values = $settings['general'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('general'), $settings['general']);
			$cronline .= $this->_getCronSetting($values, 'general');

			// Product options
			if ($notemplate) $values = $settings['product'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('product'), $settings['product']);
			$cronline .= $this->_getCronSetting($values, 'product');

			// Category options
			if ($notemplate) $values = $settings['category'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('category'), $settings['category']);
			$cronline .= $this->_getCronSetting($values, 'category');

			// Image options
			if ($notemplate) $values = $settings['image'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('image'), $settings['image']);
			$cronline .= $this->_getCronSetting($values, 'image');

			// Limit options
			if ($notemplate) $values = $settings['limit'];
			else $values = CsviHelper::recurseArrayDiff($template->getValue('limit'), $settings['limit']);
			$cronline .= $this->_getCronSetting($values, 'limit');

			// Import fields
			if ($notemplate) {
				if (array_key_exists('import_fields', $settings)) $fields = $settings['import_fields'];
				else $fields = array();
			}
			else $fields = $template->getValue('import_fields', '', array());
			if (!empty($fields)) {
				$fields['_selected_name'] = CsviHelper::recurseArrayDiff($fields['_selected_name'], $settings['import_fields']['_selected_name']);
				if (!empty($fields['_selected_name'])) {
					$cronline .= ' jform:import_fields:_selected_name = "'.implode('|', $template->getValue('_selected_name', 'import_fields')).'|"';
					$cronline .= ' jform:import_fields:_default_value = "'.implode('|', $template->getValue('_default_value', 'import_fields')).'|"';
					$cronline .= ' jform:import_fields:_process_field = "'.implode('|', $template->getValue('_process_field', 'import_fields')).'|"';
				}
			}
		}

		return $cronline;
	}

	/**
	 * Build the command to use for the cron command to do a maintenance task
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		string the parameters for the cron line
	 * @since 		3.0
	 */
	public function getCronLineMaintenance() {
		$cronline = 'task="maintenance" operation=';

		$operation = JRequest::getVar('operation');
		if (!is_array($operation)) $operation = (array)$operation;

		if (array_key_exists('0', $operation)) {
			$cronline .= '"'.strtolower($operation[0]).'"';

			// Handle the ICEcat settings
			switch ($operation[0]) {
				case 'icecatindex':
					$cronline .= ' icecatlocation="'.JRequest::getVar('icecatlocation').'"';
					$cronline .= ' icecat_gzip="'.JRequest::getVar('icecat_gzip').'"';
					$icecat_options = JRequest::getVar('icecat', array());
					if (!empty($icecat_options)) {
						$cronline .= ' icecat="'.implode('|', $icecat_options).'"';
					}
					break;
				case 'restoretemplates':
					$cronline = ' restore_file=""';
					break;
			}
		}

		return $cronline;
	}

	/**
	 * Create the cron parameter
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param 		string	$values	array of values to add to the cronline
	 * @param		string	$type	the name of the export type
	 * @return 		string	the command line
	 * @since		3.0
	 */
	private function _getCronSetting($values, $type) {
		$cronline = '';
		foreach ($values as $name => $setting) {
			switch ($name) {
				default:
					if (!empty($setting)) {
						if (is_array($setting)) {
							if (!empty($setting[0])) $cronline .= ' jform:'.$type.':'.$name.'="'.implode('|', $setting).'|"';
						}
						else $cronline .= ' jform:'.$type.':'.$name.'="'.$setting.'"';
					}
					break;
			}
		}
		return $cronline;
	}
}
?>