<?php
/**
 * Control panel model
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: csvivirtuemart.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Control panel model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelCsvivirtuemart extends JModel {
	
	/**
	 * Get the buttons for the control panel
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		object	with the button HTML data
	 * @since 		3.0
	 */
	public function getButtons() {
		// Get the Cpanel images
		$cpanel_images = new stdClass();
		$cpanel_images->import = $this->CpanelButton('csvivirtuemart_import_48.png', 'index.php?option=com_csvivirtuemart&task=import&view=import', 'COM_CSVIVIRTUEMART_IMPORT');
		$cpanel_images->export = $this->CpanelButton('csvivirtuemart_export_48.png', 'index.php?option=com_csvivirtuemart&task=export&view=export', 'COM_CSVIVIRTUEMART_EXPORT');
		$cpanel_images->maintenance = $this->CpanelButton('csvivirtuemart_maintenance_48.png', 'index.php?option=com_csvivirtuemart&task=maintenance&view=maintenance', 'COM_CSVIVIRTUEMART_MAINTENANCE');
		$cpanel_images->help = $this->CpanelButton('csvivirtuemart_help_48.png', 'http://www.csvimproved.com/csv-improved-documentation/', 'COM_CSVIVIRTUEMART_HELP');
		$cpanel_images->about = $this->CpanelButton('csvivirtuemart_about_48.png', 'index.php?option=com_csvivirtuemart&task=about&view=about', 'COM_CSVIVIRTUEMART_ABOUT');
		$cpanel_images->log = $this->CpanelButton('csvivirtuemart_log_48.png', 'index.php?option=com_csvivirtuemart&task=log&view=log', 'COM_CSVIVIRTUEMART_LOG');
		$cpanel_images->availablefields = $this->CpanelButton('csvivirtuemart_av_fields_48.png', 'index.php?option=com_csvivirtuemart&task=availablefields&view=availablefields', 'COM_CSVIVIRTUEMART_AVAILABLE_FIELDS');
		$cpanel_images->settings = $this->CpanelButton('csvivirtuemart_settings_48.png', 'index.php?option=com_csvivirtuemart&task=settings&view=settings', 'COM_CSVIVIRTUEMART_SETTINGS');
		return $cpanel_images;
	}
	 
	/**
	 * Creates a button for the control panel 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 		string	$image	contains the name of the image
	 * @param 		string	$link 	contains the target link for the image when clicked
	 * @param 		string	$title 	contains the title of the button
	 * @return		string returns a complete button for the control panel  
	 * @since 		3.0
	 */
	private function CpanelButton($image, $link, $title) {
		if (substr($link, 0, 4) == "http") $attribs = ' target="_new"';
		else $attribs = '';
		$cpanelbutton = '<div class="cpanel_button">';
		$cpanelbutton .= '	<div class="icon">';
		$cpanelbutton .= JHTML::_('link', $link, JHTML::_('image', JURI::root().'administrator/components/com_csvivirtuemart/assets/images/'.$image, JText::_($title)).'<span>'.JText::_($title).'</span>', $attribs);
		$cpanelbutton .= '	</div>';
		$cpanelbutton .= '</div>';
		return $cpanelbutton;
	}
}
?>