<?php
/**
 * Category details export class
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: categorydetailsexport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
 
/**
 * Processor for category details exports
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 */
class CsvivirtuemartModelCategoryDetailsExport extends CsvivirtuemartModelExportfile {
	
	/**
	 * Category details export
	 *
	 * Exports category details data to either csv, xml or HTML format 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function getStart() {
		
		// Get some basic data
		$db = JFactory::getDBO();
		$csvidb = new CsviDb();
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');
		$exportclass =  JRequest::getVar('export.class');
		$export_fields = JRequest::getVar('export.fields');
		
		// Get all categories
		 $query  = "SELECT LOWER(category_name) AS category_name, category_child_id AS cid, category_parent_id AS pid
			  FROM #__vm_category, #__vm_category_xref 
			  WHERE #__vm_category.category_id = #__vm_category_xref.category_child_id ";
			  
		 // Execute the query
		 $db->setQuery($query);
		 $cats = $db->loadObjectList();
		 
		 $categories = array();
		 // Group all categories together according to their level
		 foreach ($cats as $key => $cat) {
		    $categories[$cat->pid][$cat->cid] = $cat->category_name;
		 }
	
		 // Execute the query
		 $q = "SELECT category_id,
				category_description,
				category_thumb_image,
				category_name,
				category_full_image,
				category_publish,
				category_browsepage,
				products_per_row AS category_products_per_row,
				category_flypage,
				list_order AS category_list_order
				FROM #__vm_category ";
	
		
		// Check if there are any selectors
		$selectors = array();
		
		// Filter by published state
		$publish_state = $template->getValue('publish_state', 'general');
		if (!empty($publish_state)) {
			$selectors[] = '#__vm_category.category_publish = '.$db->Quote($publish_state);
		}		
				
		// Check if we need to attach any selectors to the query
		if (count($selectors) > 0 ) $q .= "\n WHERE ".implode("\n AND ", $selectors)."\n";
		
		// Ignore fields
		$ignore = array('category_path');
		
		// Check if we need to group the orders together
		$groupby = $template->getValue('groupby', 'general', false, 'bool');
		if ($groupby) $q .= $this->getFilterBy('groupby', $ignore); 
		
		// Order by set field
		$q .= $this->getFilterBy('sort', $ignore);
		
		// Add a limit if user wants us to
		$q .= $this->getExportLimit();
		
		// Execute the query
		$csvidb->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_EXPORT_QUERY'), true);
		
		// There are no records, write SQL query to log
		if ($csvidb->getErrorNum() > 0) {
			$this->addExportContent(JText::sprintf('COM_CSVIVIRTUEMART_ERROR_RETRIEVING_DATA', $csvidb->getErrorMsg()));
			$this->writeOutput();
			$csvilog->AddStats('incorrect', $csvidb->getErrorMsg());
		}
		else {
			$logcount = $csvidb->getNumRows();
			JRequest::setVar('logcount', array('export' => $logcount));
			if ($logcount > 0) {
				while ($record = $csvidb->getRow()) {
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') $this->addExportContent($exportclass->NodeStart());
					foreach ($export_fields as $column_id => $field) {
						$fieldname = $field->field_name;
						$fieldreplace = $field->field_name.$field->column_header;
						// Add the replacement
						if (isset($record->$fieldname)) $fieldvalue = CsviHelper::replaceValue($fieldreplace, $record->$fieldname);
						else $fieldvalue = '';
						switch ($fieldname) {
							case 'category_path':
							   $fieldvalue = $this->createCategoryPath($record->category_id);
							   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
							   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
							   break;
							case 'category_name':
								// Check if we have any content otherwise use the default value
								if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
								$this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
								break;
							default:
							   // Check if we have any content otherwise use the default value
							   if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
							   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header);
							   break;
						}
					}
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') {
						$this->addExportContent($exportclass->NodeEnd());
					}
					
					// Output the contents
					$this->writeOutput();
				}
			}
			else {
				$this->addExportContent(JText::_('COM_CSVIVIRTUEMART_NO_DATA_FOUND'));
				// Output the contents
				$this->writeOutput();
			}
		}
	}
}
?>