<?php
/**
 * Manufacturer details export class
 *          
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: manufacturerexport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
 
/**
 * Processor for manufacturer details exports
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 */
class CsvivirtuemartModelManufacturerExport extends CsvivirtuemartModelExportfile {
	
	// Private variables
	private $_exportmodel = null;
	
	/**
	 * Manufacturer details export
	 *
	 * Exports manufacturer details data to either csv, xml or HTML format 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function getStart() {
		
		// Get some basic data
		$db = JFactory::getDBO();
		$csvidb = new CsviDb();
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');
		$exportclass =  JRequest::getVar('export.class');
		$export_fields = JRequest::getVar('export.fields');
		
		// Match the fieldnames to the column headers
		$fieldnames = array();
		$fieldnames['manufacturer_name'] = 'mf_name';
		$fieldnames['manufacturer_email'] = 'mf_email';
		$fieldnames['manufacturer_desc'] = 'mf_desc';
		$fieldnames['manufacturer_category_name'] = 'mf_category_name';
		$fieldnames['manufacturer_category_id'] = 'mf_category_id';
		$fieldnames['manufacturer_url'] = 'mf_url';
		$fieldnames['manufacturer_id'] = 'manufacturer_id';
		 
		foreach ($export_fields as $column_id => $field) {
			switch ($field->field_name) {
				case 'manufacturer_name':
					$userfields[] = 'mf_name AS manufacturer_name ';
					break;
				case 'manufacturer_email':
					$userfields[] = 'mf_email AS manufacturer_email';
					break;
				case 'manufacturer_desc':
					$userfields[] = 'mf_desc AS manufacturer_desc';
					break;
				case 'manufacturer_category_name':
					$userfields[] = 'mf_category_name AS manufacturer_category_name';
					break;
				case 'manufacturer_category_id':
					$userfields[] = 'c.mf_category_id AS manufacturer_category_id';
					break;
				case 'manufacturer_url':
					$userfields[] = 'mf_url AS manufacturer_url';
					break;
				default:
					$userfields[] = '`'.$field->field_name.'`';
					break;
			}
		}
		 
		 // Get the template settings
		 $q = "SELECT ".implode(",\n", $userfields)." 
		 	FROM #__vm_manufacturer m, #__vm_manufacturer_category c
			WHERE m.mf_category_id = c.mf_category_id ";
		
		// Special fields
		$special = array();
		$special['manufacturer_category_id'] = $db->nameQuote('c').'.'.$db->nameQuote('mf_category_id');
		$special['manufacturer_desc'] = $db->nameQuote('mf_desc');
		$special['manufacturer_email'] = $db->nameQuote('mf_email');
		$special['manufacturer_name'] = $db->nameQuote('mf_name');
		$special['manufacturer_url'] = $db->nameQuote('mf_url');
		
		// Check if we need to group the orders together
		$groupby = $template->getValue('groupby', 'general', false, 'bool');
		if ($groupby) $q .= $this->getFilterBy('groupby', array(), $special); 
		
		// Order by set field
		$q .= $this->getFilterBy('sort', array(), $special);
		
		// Add a limit if user wants us to
		$q .= $this->getExportLimit();
		
		// Execute the query
		$csvidb->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_EXPORT_QUERY'), true);
		// There are no records, write SQL query to log
		if ($csvidb->getErrorNum() > 0) {
			$this->addExportContent(JText::sprintf('COM_CSVIVIRTUEMART_ERROR_RETRIEVING_DATA', $csvidb->getErrorMsg()));
			$this->writeOutput();
			$csvilog->AddStats('incorrect', $csvidb->getErrorMsg());
		}
		else {
			$logcount = $csvidb->getNumRows();
			JRequest::setVar('logcount', array('export' => $logcount));
			if ($logcount > 0) {
				while ($record = $csvidb->getRow()) {
					
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') $this->addExportContent($exportclass->NodeStart());
					foreach ($export_fields as $column_id => $field) {
						$fieldname = $field->field_name;
						$fieldreplace = $field->field_name.$field->column_header;
						// Add the replacement
						if (isset($record->$fieldname)) $fieldvalue = CsviHelper::replaceValue($fieldreplace, $record->$fieldname);
						else $fieldvalue = '';
						// Check if we have any content otherwise use the default value
						if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
						$this->addExportField($field->combine, $fieldvalue, $field->field_name, $field->column_header);
					}
					
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') {
						$this->addExportContent($exportclass->NodeEnd());
					}
					
					// Output the contents
					$this->writeOutput();
				}
			}
			else {
				$this->addExportContent(JText::_('COM_CSVIVIRTUEMART_NO_DATA_FOUND'));
				// Output the contents
				$this->writeOutput();
			}
		}
	}
}
?>