<?php
/**
 * Product files export class
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: productfilesexport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
 
/**
 * Processor for product files exports
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 */
class CsvivirtuemartModelProductFilesExport extends CsvivirtuemartModelExportfile {
	
	/**
	 * Product files export
	 *
	 * Exports product files data to either csv, xml or HTML format 
	 * 
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.0
	 */
	public function getStart() {
		
		// Get some basic data
		$db = JFactory::getDBO();
		$csvidb = new CsviDb();
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');
		$exportclass =  JRequest::getVar('export.class');
		$export_fields = JRequest::getVar('export.fields');
		
		// Execute the query
		$q = "SELECT j.*, p.product_sku, IF (a.attribute_name = 'download', 'Y', 'N') AS product_files_download 
		 	FROM #__vm_product_files j
			LEFT JOIN #__vm_product p
			ON j.file_product_id = p.product_id 
			LEFT JOIN #__vm_product_attribute a
			ON j.file_product_id = a.product_id ";
		
		// Check if there are any selectors
		$selectors = array();
		
		// Filter by published state
		$publish_state = $template->getValue('publish_state', 'general');
		if (!empty($publish_state)) {
			$selectors[] = 'j.file_published = '.$db->Quote($publish_state);
		}		
				
		// Check if we need to attach any selectors to the query
		if (count($selectors) > 0 ) $q .= "\n WHERE ".implode("\n AND ", $selectors)."\n";	
		
		// Ignore fields
		$ignore = array('product_files_download'); 
		// Special fields
		$special = array();
		$special['product_files_file_description'] = $db->nameQuote('file_description');
		$special['product_files_file_name'] = $db->nameQuote('file_name');
		$special['product_files_file_published'] = $db->nameQuote('file_published');
		$special['product_files_file_title'] = $db->nameQuote('file_title');
		$special['product_files_file_url'] = $db->nameQuote('file_url');
		
		// Check if we need to group the orders together
		$groupby = $template->getValue('groupby', 'general', false, 'bool');
		if ($groupby) $q .= $this->getFilterBy('groupby', $ignore, $special); 
		
		// Order by set field
		$q .= $this->getFilterBy('sort', $ignore, $special);
		
		// Add a limit if user wants us to
		$q .= $this->getExportLimit();
		 
		// Execute the query
		$csvidb->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_EXPORT_QUERY'), true);
		// There are no records, write SQL query to log
		if ($csvidb->getErrorNum() > 0) {
			$this->addExportContent(JText::sprintf('COM_CSVIVIRTUEMART_ERROR_RETRIEVING_DATA', $csvidb->getErrorMsg()));
			$this->writeOutput();
			$csvilog->AddStats('incorrect', $csvidb->getErrorMsg());
		}
		else {
			$logcount = $csvidb->getNumRows();
			JRequest::setVar('logcount', array('export' => $logcount));
			if ($logcount > 0) {
				while ($record = $csvidb->getRow()) {
					
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') $this->addExportContent($exportclass->NodeStart());
					foreach ($export_fields as $column_id => $field) {
					  $fieldname = $field->field_name;
					  $fieldreplace = $field->field_name.$field->column_header;
					  switch ($fieldname) {
						case "product_files_file_published":
						   if ($record->file_published == 1) $fieldvalue = 'Y';
						   else $fieldvalue = 'N';
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header);
						   break;
						case "product_files_file_name":
						   $fieldvalue = $record->file_name;
						   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
						   break;
						case "product_files_file_title":
						   $fieldvalue = $record->file_title;
						   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
						   break;
						case "product_files_file_description":
						   $fieldvalue = $record->file_description;
						   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
						   break;
						case "product_files_file_url":
						   $fieldvalue = $record->file_url;
						   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header, true);
						   break;
						default:
						   $fieldvalue = $record->$fieldname;
						   $fieldvalue = CsviHelper::replaceValue($fieldreplace, $fieldvalue);
						   $this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header);
						   break;
					  }
					}
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') {
						$this->addExportContent($exportclass->NodeEnd());
					}
					
					// Output the contents
					$this->writeOutput();
				 }
			}
			else {
				$this->addExportContent(JText::_('COM_CSVIVIRTUEMART_NO_DATA_FOUND'));
				// Output the contents
				$this->writeOutput();
			}
		}
	}
}
?>