<?php
/**
 * Waiting list export class
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: waitinglistexport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
 
/**
 * Processor for waiting list exports
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 */
class CsvivirtuemartModelWaitinglistExport extends CsvivirtuemartModelExportfile {
	
	// Private variables
	private $_exportmodel = null;
	
	/**
	 * Waiting list export
	 *
	 * @copyright 
	 * @author		RolandD 
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 		void
	 * @since 		3.1
	 */
	public function getStart() {
		
		// Get some basic data
		$db = JFactory::getDBO();
		$csvidb = new CsviDb();
		$csvilog = JRequest::getVar('csvilog');
		$template = JRequest::getVar('template');
		$exportclass =  JRequest::getVar('export.class');
		$export_fields = JRequest::getVar('export.fields');
		
		// Build something fancy to only get the fieldnames the user wants
		$userfields = array();
		foreach ($export_fields as $column_id => $field) {
			if ($field->process) {
				switch ($field->field_name) {
					case 'cdate':
					case 'product_cdate':
						$userfields[] = '#__vm_product.cdate';
						break;
					case 'mdate':
					case 'product_mdate':
						$userfields[] = '#__vm_product.mdate';
						break;
					case 'product_id':
						$userfields[] = '#__vm_waiting_list.product_id';
						break;
					case 'user_id':
						$userfields[] = '#__vm_waiting_list.user_id';
						break;
					// Man made fields, do not export them 
					case 'custom':
						break;
					default:
						$userfields[] = '`'.$field->field_name.'`';
						break;
				}
			}
		}
		
		// Execute the query
		$q = "SELECT ".implode(",\n", $userfields);
		$q .= " FROM `#__vm_waiting_list`
			LEFT JOIN `#__vm_product`
			ON `#__vm_product`.product_id = `#__vm_waiting_list`.product_id
			LEFT JOIN `#__vm_user_info`
			ON `#__vm_user_info`.user_id = `#__vm_waiting_list`.user_id";
		
		// Ignore fields	
		$ignore = array();
		
		// Special fields
		$special = array();
		$special['product_cdate'] = $db->nameQuote('#__vm_product').'.'.$db->nameQuote('cdate');
		$special['product_mdate'] = $db->nameQuote('#__vm_product').'.'.$db->nameQuote('mdate');
		$special['product_id'] = $db->nameQuote('#__vm_waiting_list').'.'.$db->nameQuote('product_id');
		
		// Check if we need to group the orders together
		$groupby = $template->getValue('groupby', 'general', false, 'bool');
		if ($groupby) $q .= $this->getFilterBy('groupby', $ignore, $special); 	
		
		// Order by set field
		$q .= $this->getFilterBy('sort');
		
		// Add a limit if user wants us to
		$q .= $this->getExportLimit();
		
		// Execute the query
		$csvidb->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_EXPORT_QUERY'), true);
		// There are no records, write SQL query to log
		if ($csvidb->getErrorNum() > 0) {
			$this->addExportContent(JText::sprintf('COM_CSVIVIRTUEMART_ERROR_RETRIEVING_DATA', $csvidb->getErrorMsg()));
			$this->writeOutput();
			$csvilog->AddStats('incorrect', $csvidb->getErrorMsg());
		}
		else {
			$logcount = $csvidb->getNumRows();
			JRequest::setVar('logcount', array('export' => $logcount));
			if ($logcount > 0) {
				while ($record = $csvidb->getRow()) {
					
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') $this->addExportContent($exportclass->NodeStart());
					foreach ($export_fields as $column_id => $field) {
						$fieldname = $field->field_name;
						$fieldreplace = $field->field_name.$field->column_header;
						// Add the replacement
						if (isset($record->$fieldname)) $fieldvalue = CsviHelper::replaceValue($fieldreplace, $record->$fieldname);
						else $fieldvalue = '';
						switch ($fieldname) {
							default:
								// Check if we have any content otherwise use the default value
								if (strlen(trim($fieldvalue)) == 0) $fieldvalue = $field->default_value;
								$this->addExportField($field->combine, $fieldvalue, $fieldname, $field->column_header);
								break;
						}
					}
					if ($template->getValue('export_file', 'general') == 'xml' || $template->getValue('export_file', 'general') == 'html') {
						$this->addExportContent($exportclass->NodeEnd());
					}
					
					// Output the contents
					$this->writeOutput();
				}
			}
			else {
				$this->addExportContent(JText::_('COM_CSVIVIRTUEMART_NO_DATA_FOUND'));
				// Output the contents
				$this->writeOutput();
			}
		}
	}
}
?>