<?php
/**
 * Manufacturer import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: manufacturerimport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for manufacturer import
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelManufacturerimport extends CsvivirtuemartModelImportfile {

	// Private tables
	/** @var object contains the vm_manufacturer table */
	private $_vm_manufacturer = null;
	/** @var object contains the vm_manufacturer table */
	private $_vm_manufacturer_category = null;

	// Public variables
	/** @var integer contains the manufacturer ID */
	public $manufacturer_id = null;
	/** @var integer contains the category ID for a manufacturer */
	public $category_id = null;
	/** @var integer contains the manufacturer category ID for a product */
	public $mf_category_id = null;
	/** @var string sets if the manufacturer should be deleted */
	public $manufacturer_delete = 'N';

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

    /**
     * Refresh the settings for XML nodes
     *
     * @copyright
     * @author 		RolandD
     * @todo
     * @see
     * @access 		protected
     * @param
     * @return
     * @since 		3.8.2
     */
	protected function refresh() {
		$this->loadSettings();
	}

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Check for vendor ID
		$this->vendor_id = $this->getVendorId();

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'manufacturer_name':
								$this->mf_name = $this->_datafield;
								break;
							case 'manufacturer_desc':
								$this->mf_desc = $this->_datafield;
								break;
							case 'manufacturer_email':
								$this->mf_email = $this->_datafield;
								break;
							case 'manufacturer_url':
								$this->mf_url = $this->_datafield;
								break;
							case 'manufacturer_category_id':
								$this->mf_category_id = $this->_datafield;
								break;
							case 'manufacturer_category_name':
								$this->mf_category_name = $this->_datafield;
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');

		// Check if we need to get manufacturer category ID
		if (!isset($this->mf_category_id) && isset($this->mf_category_name)) {
			$this->_vm_manufacturer_category->bind($this);
			$this->_vm_manufacturer_category->setValue('mf_update', 'mf_category_name');
			$this->_vm_manufacturer_category->check();
			$this->mf_category_id = $this->_vm_manufacturer_category->getValue('mf_category_id');
		}

		// Bind the data
		$this->_vm_manufacturer->bind($this);

		// Check if we need to delete the manufacturer
		if ($this->manufacturer_delete == 'Y') {
			$db = JFactory::getDBO();
			$q = "DELETE FROM #__vm_product_mf_xref
				WHERE manufacturer_id=".$this->mf_category_id;
			$db->setQuery($q);
			if ($db->query()) {
				$csvilog->addStats('deleted', JText::_('COM_CSVIVIRTUEMART_MANUFACTURER_XREF_DELETED'));
			}
			else {
				$csvilog->addStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_MANUFACTURER_XREF_NOT_DELETED', $db->getErrorMsg()));
			}

			if ($this->_vm_manufacturer->delete()) {
				$csvilog->AddStats('deleted', JText::_('COM_CSVIVIRTUEMART_DELETE_MANUFACTURER'));
			}
			else {
				$csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_MANUFACTURER_NOT_DELETED', $this->_vm_manufacturer->getError()));
			}
		}
		else {
			// Store the data
			if ($this->_vm_manufacturer->store()) {
				if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_MANUFACTURER'));
				else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_MANUFACTURER'));

				$this->manufacturer_id = $this->_vm_manufacturer->getValue('manufacturer_id');
			}
			else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_MANUFACTURER_NOT_ADDED', $this->_vm_manufacturer->getError()));

			// Store the debug message
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_MANUFACTURER_QUERY'), true);
		}

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the manufacturer related tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_manufacturer = $this->getTable('vm_manufacturer');
		$this->_vm_manufacturer_category = $this->getTable('vm_manufacturer_category');
	}

	/**
	 * Cleaning the manufacturer related tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_manufacturer->reset();
		$this->_vm_manufacturer_category->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}
}
?>
