<?php
/**
 * Product types import
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: producttypeimport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for product types
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelProducttypeimport extends CsvivirtuemartModelImportfile {

	// Private tables
	/** @var object contains the vm_product_files table */
	private $_vm_product_type = null;

	// Public variables
	/** @var mixed contains the ID for the product type */
	public $product_type_id = null;

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;
	/** @var boolean contains the setting if a new product type table needs to be created */
	private $create_table = false;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

    /**
     * Refresh the settings for XML nodes
     *
     * @copyright
     * @author 		RolandD
     * @todo
     * @see
     * @access 		protected
     * @param
     * @return
     * @since 		3.8.2
     */
	protected function refresh() {
		$this->loadSettings();
	}

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Get the file_product_id
		$this->file_product_id = $this->getProductId();

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}

		// Check if the list order is empty
		if (!isset($this->product_type_list_order)) $this->_productTypeListOrder();

		// All good
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function getProcessRecord() {
		$csvilog = JRequest::getVar('csvilog');

		// Bind the data
		$this->_vm_product_type->bind($this);

		// Check if we already have a product type ID
		if (is_null($this->product_type_id)) {
			$this->_vm_product_type->check();
			if (is_null($this->_vm_product_type->getValue('product_type_id'))) {
				$this->create_table = true;
			}
		}

		// Store the data
		if ($this->_vm_product_type->store()) {
			if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_PRODUCTTYPE'));
			else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_PRODUCTTYPE'));
		}
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_PRODUCTTYPE_NOT_ADDED', $this->_vm_product_type->getError()));

		// Store the debug message
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_PRODUCTTYPE_QUERY'), true);

		if ($this->create_table) {
			$this->product_type_id = $this->_vm_product_type->getValue('product_type_id');
			// We have a new product type, need to create the table
			if ($this->_createProductTypeTable()) {
				$csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_CREATED_PRODUCT_TYPE_TABLE'));
			}
			else {
				$csvilog->AddStats('error', JText::_('COM_CSVIVIRTUEMART_ERROR_CREATED_PRODUCT_TYPE_TABLE'));
			}
		}

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the product type related tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _loadTables() {
		$this->_vm_product_type = $this->getTable('vm_product_type');
	}

	/**
	 * Cleaning the product type related tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.0
	 */
	protected function cleanTables() {
		$this->_vm_product_type->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}

	/**
	 * Get the highest list order and add 1 for the new list order
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.0
	 */
	private function _productTypeListOrder() {
		$db = JFactory::getDBO();

		$q = "SELECT MAX(product_type_list_order) AS list_order
			FROM #__vm_product_type";
		$db->setQuery($q);
		$db->query();
		$this->product_type_list_order = $db->loadResult()+1;
	}

	/**
	 * New product types require new tables
	 *
	 * Tables are created with the name product_type_<id>
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		bool	true if table is created | false if table cannot be created
	 * @since 		3.0
	 */
	private function _createProductTypeTable() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');

		$q = "CREATE TABLE IF NOT EXISTS `#__vm_product_type_";
		$q .= $this->product_type_id . "` (";
		$q .= $db->nameQuote('product_id')." int(11) NOT NULL,";
		$q .= "PRIMARY KEY (".$db->nameQuote('product_id').")";
		$q .= ")ENGINE=MyISAM";
		$db->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CREATE_PRODUCT_TYPE_TABLE'), true);
		if ($db->query()) return true;
		else return false;
	}
}
?>