<?php
/**
 * Tax rates import
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: taxratesimport.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Processor for tax rates
 *
 * VirtueMart columns:
 * tax_rate_id
 * vendor_id
 * tax_state
 * tax_country
 * tax_rate
 * mdate
 *
 * FlexTax columns:
 * tax_class_id
 * tax_type
 * tax_city
 * tax_county
 * tax_zip_start
 * tax_zip_end
 * tax_hst
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelTaxratesimport extends CsvivirtuemartModelImportfile {

	// Private tables
	/** @var object contains the vm_tax_rate table */
	private $_vm_tax_rate = null;

	// Public variables
	public $mdate = null;
	public $vendor_id = 1;
	public $tax_rate_id = null;
	public $tax_state = '';
	public $tax_country = '';
	public $tax_city = '';
	public $tax_county = '';
	public $tax_class_id = 0;
	public $tax_type = 0;
	public $tax_zip_start = 0;
	public $tax_zip_end = 0;
	public $tax_hst = 0;

	// Private variables
	/** @var mixed contains the data of the current field being processed */
	private $_datafield = null;
	/** @var object contains general import functions */
	private $_importmodel = null;

	/**
	 * Constructor
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.4
	 */
	public function __construct() {
		parent::__construct();
		// Load the tables that will contain the data
		$this->_loadTables();
		$this->loadSettings();
    }

    /**
     * Refresh the settings for XML nodes
     *
     * @copyright
     * @author 		RolandD
     * @todo
     * @see
     * @access 		protected
     * @param
     * @return
     * @since 		3.8.2
     */
	protected function refresh() {
		$this->loadSettings();
	}

	/**
	 * Here starts the processing
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.1
	 */
	public function getStart() {
		// Load the data
		$this->loadData();

		// Get the logger
		$csvilog = JRequest::getVar('csvilog');

		// Process data
		foreach ($this->_csvifields as $name => $details) {
			if ($details['published']) {
				$this->_datafield = $this->validateInput($name);
				if ($this->_datafield !== false) {
					// Check if we are dealing with the last field
					if ($details == $this->_lastfield) $details['combine'] = false;

					// See if we are combining the field
					if ($details['combine']) $this->setCombineField($this->_datafield, $name);
					else {
						// Check if there are any fields to be combined
						if (!empty($this->combine_fields)) {
							// Get the fieldname the combine is for
							$name = $this->combine_settings['fieldname'];
							// Add the current data
							$this->setCombineField($this->_datafield);
							// Get the combined data
							$this->_datafield = $this->getCombineField();
						}
						// Check if the field needs extra treatment
						switch ($name) {
							case 'mdate':
								$this->$name = $this->convertDate($this->_datafield);
								break;
							default:
								$this->$name = $this->_datafield;
								break;
						}
					}
				}
				else return false;
			}
		}
		return true;
	}

	/**
	 * Process each record and store it in the database
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.1
	 */
	public function getProcessRecord() {
		// Get the imported values
		$csvilog = JRequest::getVar('csvilog');
		$db = JFactory::getDBO();

		// Set the tax rate
		$this->tax_rate = ($this->product_tax/100);

		// Get the tax rate ID
		$this->_getTaxRateId();

		// Check if we  have a modification date
		if (empty($this->mdate)) $this->mdate = time();

		// Bind the data
		$this->_vm_tax_rate->bind($this);

		// Store the data
		if ($this->_vm_tax_rate->store()) {
			if ($this->queryResult() == 'UPDATE') $csvilog->AddStats('updated', JText::_('COM_CSVIVIRTUEMART_UPDATE_TAX_RATE'));
			else $csvilog->AddStats('added', JText::_('COM_CSVIVIRTUEMART_ADD_TAX_RATE'));
		}
		else $csvilog->AddStats('incorrect', JText::sprintf('COM_CSVIVIRTUEMART_TAX_RATE_NOT_ADDED', $this->_vm_tax_rate->getError()));

		// Store the debug message
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_TAX_RATE_QUERY'), true);

		// Clean the tables
		$this->cleanTables();
	}

	/**
	 * Load the tax tables
	 *
	 * @copyright
	 * @author		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.1
	 */
	private function _loadTables() {
		$this->_vm_tax_rate = $this->getTable('vm_tax_rate');
	}

	/**
	 * Cleaning the tax tables
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		3.1
	 */
	protected function cleanTables() {
		$this->_vm_tax_rate->reset();

		// Clean local variables
		$class_vars = get_class_vars(get_class($this));
		foreach ($class_vars as $name => $value) {
			if (substr($name, 0, 1) != '_') {
				$this->$name = $value;
			}
		}
	}

	/**
	 * Get the tax rate ID
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return
	 * @since 		3.1
	 */
	private function _getTaxRateId() {
		$db = JFactory::getDBO();
		$template = JRequest::getVar('template');
		$csvilog = JRequest::getVar('csvilog');
		$q = "SELECT tax_rate_id
			FROM #__vm_tax_rate
			WHERE tax_country = ".$db->Quote($this->tax_country)."
			AND tax_state = ".$db->Quote($this->tax_state)."
			AND tax_rate = ".$this->tax_rate;
		if ($template->getValue('use_flextax', 'tax', false, 'bool')) {
			$q .= " AND tax_county = ".$db->Quote($this->tax_county);
			$q .= " AND tax_city = ".$db->Quote($this->tax_city);
		}
		// Set the query
		$db->setQuery($q);
		$this->tax_rate_id = $db->loadResult();
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_DEBUG_FIND_TAX_RATE_ID'), true);
	}
}
?>
