<?php
/**
 * Settings model
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: settings.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Settings Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelSettings extends JModel {

	/** @var string Path to the configuration file */
	private $_paramsdefs = null;

	/** @var array The parameter object */
	private $_params = false;

	/**
	* Basic settings
	*/
	public function __construct() {
		$this->_paramsdefs = JPATH_COMPONENT_ADMINISTRATOR.'/views/settings/config.xml';
		parent::__construct();
	}

	/**
	* Load the CSVI VitueMart settings
	*
	* Id is fixed for 1
	*/
	public function getSettings() {
		if (!$this->_params) {
			$row  = $this->getTable('csvivirtuemart_settings');
			$row->load(1);
			$this->_params = new JParameter($row->params, $this->_paramsdefs);
		}
		return $this->_params;
	}

	/**
	* Store the component parameters
	 */
	 public function getSaveSettings() {
		$row  = $this->getTable('csvivirtuemart_settings');
		$params = new JParameter('', $this->_paramsdefs);
		$params->bind(JRequest::getVar('params'));

		// Set the values
		$row->id = 1;
		$row->params = $params->toString();
		if ($row->store()) {
			$this->_params = $params;
			return true;
		}
		else return false;
	 }

	/**
	* Get a requested value
	*
	* @param string $setting the setting to get the value for
	* @param mixed $default the default value if no $setting is found
	*/
	public function getSetting($setting, $default=false) {
		if (!$this->_params) $this->getSettings();
		return $this->_params->get($setting, $default);
	}

	/**
	 * Get a list of custom tables for import/export
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		array	of tables
	 * @since 		3.0
	 */
	public function getTableList() {
		$db = JFactory::getDBO();
		$tables = $db->getTableList();
		// Remove the table prefix
		foreach ($tables as $tkey => $table) {
			$tables[$tkey] = str_replace($db->getPrefix(), '', $table);
		}
		return $tables;
	}

	/**
	 * Reset the settings
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		bool	true if settings reset | false if settings not reset
	 * @since 		3.1.1
	 */
	public function getResetSettings() {
		$row  = $this->getTable('csvivirtuemart_settings');
		$row->id = 1;
		$row->params = '';
		return $row->store();
	}
}
?>