<?php
/**
 * Template types model
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: about.php 1574 2011-04-16 15:00:03Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.model' );

/**
 * Template types Model
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelTemplatetypes extends JModel {

	/**
	 * Get all the template types
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		array of available template types
	 * @since 		3.5
	 */
	public function getTemplatetypes() {
		$db = JFactory::getDbo();
		$q = "SELECT *
			FROM #__csvivirtuemart_template_types
			ORDER BY template_type_name";
		$db->setQuery($q);
		$result = $db->loadObjectList();

		// Load the lowest product ID
		$q = "SELECT MIN(product_id)
			FROM #__vm_product";
		$db->setQuery($q);
		$productid = $db->loadResult();

		// Load the component names
		$q = "SELECT t.component, c.name
			FROM `#__csvivirtuemart_template_types` AS t
			LEFT JOIN `#__components` AS c ON t.component = c.`option`
			GROUP BY t.component";
		$db->setQuery($q);
		$components = $db->loadAssocList('component');

		$templates = array();
		foreach ($result as $key => $template) {
			switch ($template->template_type_name) {
				case 'categorydetailsexport':
				case 'categorydetailsimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=product.product_category_list&option=com_virtuemart');
					break;
				case 'couponsexport':
				case 'couponsimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=coupon.coupon_list&option=com_virtuemart');
					break;
				case 'manufacturersexport':
				case 'manufacturersimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=manufacturer.manufacturer_list&option=com_virtuemart');
					break;
				case 'multiplepricesexport':
				case 'multiplepricesimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?page=product.product_price_list&product_id='.$productid.'&option=com_virtuemart');
					break;
				case 'orderexport':
				case 'orderimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=order.order_list&option=com_virtuemart');
					break;
				case 'productexport':
				case 'productimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=product.product_list&option=com_virtuemart');
					break;
				case 'productfilesexport':
				case 'productfilesimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?page=product.file_list&product_id='.$productid.'&option=com_virtuemart');
					break;
				case 'productreviewsexport':
				case 'productreviewsimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=product.review_list&option=com_virtuemart');
					break;
				case 'producttypeexport':
				case 'producttypeimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=product.product_type_list&option=com_virtuemart');
					break;
				case 'producttypeparametersexport':
				case 'producttypeparametersimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?option=com_virtuemart&page=product.product_type_parameter_list');
					break;
				case 'shippingratesexport':
				case 'shippingratesimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=shipping.rate_list&option=com_virtuemart');
					break;
				case 'taxratesexport':
				case 'taxratesimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=tax.tax_list&option=com_virtuemart');
					break;
				case 'userfieldsexport':
				case 'userfieldsimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=admin.user_field_list&option=com_virtuemart');
					break;
				case 'userinfoexport':
				case 'userinfoimport':
					$templates[$template->template_type][$key]['url'] = JRoute::_('index.php?pshop_mode=admin&page=admin.user_list&option=com_virtuemart');
					break;
				case 'vmf_featuresexport':
				case 'vmf_featuresimport':
					if ($this->_componentInstalled('com_vmFiltering')) $templates[$template->template_type][$key]['url'] = JRoute::_('index.php?option=com_vmFiltering&controller=categories');
					else $templates[$template->template_type][$key]['url'] = NULL;
					break;
				case 'vmf_valuesexport':
				case 'vmf_valuesimport':
					if ($this->_componentInstalled('com_vmFiltering')) $templates[$template->template_type][$key]['url'] = JRoute::_('index.php?option=com_vmFiltering&controller=subcategories');
					else $templates[$template->template_type][$key]['url'] = NULL;
					break;
				default:
					$templates[$template->template_type][$key]['url'] = NULL;
					break;
			}
			// Set the component name
			$templates[$template->template_type][$key]['component_name'] = $components[$template->component];

			// Add the template name
			$templates[$template->template_type][$key]['name'] = $template->template_type_name;
		}
		return $templates;
	}

	/**
	 * Check if a given component is installed
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param 		$option	string	the name of the component to check
	 * @return 		bool	true if component is installed | false if component is not installed
	 * @since 		3.5
	 */
	private function _componentInstalled($option) {
		$db = JFactory::getDbo();
		$q = "SELECT COUNT(".$db->nameQuote('option').")
			FROM ".$db->nameQuote('#__components')."
			WHERE ".$db->nameQuote('option')." = ".$db->Quote($option);
		$db->setQuery($q);
		$total = $db->loadResult();
		if ($total > 0) return true;
		else return false;
	}
}
?>