<?php
/**
 * Virtuemart Product Category Cross reference table
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: vm_product_category_xref.php 1892 2012-02-11 11:01:09Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
* @package CSVIVirtueMart
 */
class TableVm_product_category_xref extends JTable {
	
	// Sets whether the database columns have been loaded
	private $_loaded = false;
	
	/**
	* @param database A database connector object
	 */
	function __construct($db) {
		$this->reset();
		parent::__construct('#__vm_product_category_xref', 'product_id', $db );
	}
	
	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}
	
	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}
	
	/**
	* Resets the default properties
	* @return	void
	 */
	function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vm_product_category_xref'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}
	
	/**
	* Stores a product category relation
	*
	* The product category relation is always inserted
	 */
	public function store() {
		$csvilog = JRequest::getVar('csvilog');
		// Check if the entry already exists
		if (!$this->checkDuplicate()) {
			$ret = $this->_db->insertObject( $this->_tbl, $this);
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_ADD_NEW_CATEGORY_REFERENCES'), true);
			if (!$ret) {
				$this->setError(get_class($this).'::store failed - '.$this->_db->getErrorMsg());
				return false;
			}
			else return true;
		}
		else return true;
	}
	
	/**
	* Check if the entry already exists
	 */
	private function checkDuplicate() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		$q = "SELECT COUNT(*) AS total
			FROM ".$this->_tbl."
			WHERE product_id = ".$this->product_id."
			AND category_id = ".$this->category_id;
		$db->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CHECK_IF_CATEGORY_REFERENCE_ALREADY_EXISTS'), true);
		$total = $db->loadResult();
		if ($total > 0) {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CATEGORY_REFERENCE_ALREADY_EXISTS'));
			return true;
		}
		else {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CATEGORY_REFERENCE_DOES_NOT_YET_EXIST'));
			return false;
		}
	}
	
}
?>