<?php
/**
 * Virtuemart Product Type Cross reference table
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: vm_product_product_type_xref.php 1892 2012-02-11 11:01:09Z RolandD $
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

/**
 * @package CSVIVirtueMart
 */
class TableVm_product_product_type_xref extends JTable {
	
	// Sets whether the database columns have been loaded
	private $_loaded = false;
	
	/**
	* @param database A database connector object
	 */
	function __construct($db) {
		$this->reset();
		parent::__construct('#__vm_product_product_type_xref', 'product_id', $db );
	}
	
	/**
	* Set a value for the class
	 */
	public function setValue($field, $value) {
		$this->$field = $value;
	}
	
	/**
	* Get a value from the class
	 */
	public function getValue($field) {
		return $this->$field;
	}
	
	/**
	* Resets the default properties
	* @return	void
	 */
	function reset() {
		if (!$this->_loaded) {
			$this->setProperties(CsvivirtuemartModelAvailablefields::DbFields('vm_product_product_type_xref'));
			$this->_loaded = true;
		}
		else {
			$class_vars = get_class_vars(get_class($this));
			foreach ($this as $name => $value) {
				if (substr($name, 0, 1) != '_') {
					$this->$name = null;
				}
			}
		}
	}
	
	/**
	* Store a value
	 */
	public function store() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		if (!$this->check()) {
			$q = "INSERT INTO ".$db->nameQuote( $this->_tbl )."
				VALUES (".$db->Quote($this->product_id).", ".$db->Quote($this->product_type_id).")";
			$db->setQuery($q);
			return $db->query();
		}
		else {
			$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_CROSS_REFERENCE_EXISTS'));
		}
	}
	
	/**
	* Function to check if cross reference already exists
	 */
	public function check() {
		$db = JFactory::getDBO();
		$csvilog = JRequest::getVar('csvilog');
		$q = "SELECT COUNT(product_id) AS total
			FROM ".$db->nameQuote( $this->_tbl )."
			WHERE product_id = ".$db->Quote($this->product_id)."
			AND product_type_id = ".$db->Quote($this->product_type_id);
		$db->setQuery($q);
		$csvilog->addDebug(JText::_('COM_CSVIVIRTUEMART_PRODUCT_TYPE_XREF_CHECK'), true);
		if ($db->loadResult() > 0) return true;
		else return false;
	}
}
?>