<?php
/**
 * About page
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @todo
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<table class="adminlist">
	<thead>
		<tr>
			<th width="650"><?php echo JText::_('COM_CSVIVIRTUEMART_FOLDER'); ?></th>
			<th><?php echo JText::_('COM_CSVIVIRTUEMART_FOLDER_STATUS'); ?></th>
			<th><?php echo JText::_('COM_CSVIVIRTUEMART_FOLDER_OPTIONS'); ?></th>
		</tr>
	<thead>
	<tfoot>
	</tfoot>
	<tbody>
		<?php
			$i = 1;
			foreach ($this->folders as $name => $access) { ?>
			<tr>
				<td><?php echo $name; ?></td>
				<td><?php if ($access) { echo '<span class="writable">'.JText::_('COM_CSVIVIRTUEMART_WRITABLE').'</span>'; } else { echo '<span class="not_writable">'.JText::_('COM_CSVIVIRTUEMART_NOT_WRITABLE').'</span>'; } ?>
				<td><?php if (!$access) { ?>
					<form action="index.php?option=com_csvivirtuemart&view=about">
						<input type="button" class="button" onclick="createFolder('<?php echo $name; ?>', 'createfolder<?php echo $i; ?>'); return false;" name="createfolder" value="<?php echo JText::_('COM_CSVIVIRTUEMART_FOLDER_CREATE'); ?>"/>
					</form>
					<div id="createfolder<?php echo $i;?>"></div><?php } ?>
				</td>
			</tr>
		<?php $i++; 
			} ?>
	</tbody>
</table>
<br />
<table class="adminlist">
<tr><td colspan="2"><?php echo JHTML::_('image', JURI::base().'components/com_csvivirtuemart/assets/images/csvivirtuemart_about_32.png', JText::_('COM_CSVIVIRTUEMART_ABOUT')); ?></td></tr>
<tbody>
<tr><th>Name:</th><td>CSVI VirtueMart</td></tr>
<tr><th>Version:</th><td>3.8.3</td></tr>
<tr><th><form action="index.php?option=com_csvivirtuemart&view=about"><input type="button" class="button" onclick="checkVersion(); return false;" name="checkversion" value="<?php echo JText::_('COM_CSVIVIRTUEMART_CHECK_VERSION'); ?>"/></form></th><td><div id="checkversion"></div></td></tr>
<tr><th>Coded by:</th><td>RolandD Cyber Produksi</td></tr>
<tr><th>Contact:</th><td>contact@csvimproved.com</td></tr>
<tr><th>Support:</th><td><?php echo JHTML::_('link', 'http://www.csvimproved.com/', 'CSVI VirtueMart Homepage', 'target="_blank"'); ?></td></tr>
<tr><th>Copyright:</th><td>Copyright (C) 2006 - 2011 RolandD Cyber Produksi</td></tr>
<tr><th>License:</th><td><?php echo JHTML::_('link', 'http://www.gnu.org/licenses/gpl-3.0.html', 'GNU/GPL v3'); ?></td></tr>
</tbody>
</table>
<script type="text/javascript">
function checkVersion() {
	var spinner = jQuery('#checkversion').html("<img src='/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_ajax-loading.gif' />");
	jQuery.ajax({
		async: false,
		url: 'index.php',
		dataType: 'json',
		data: 'option=com_csvivirtuemart&view=about&task=checkversion&format=json',
		success: function(data) {
			jQuery('#checkversion').html(data);
		},
		failure: function() {
			jQuery('#checkversion').html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_CHECKING_VERSION'); ?>');
		},
		error: function() {
			jQuery('#checkversion').html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_CHECKING_VERSION'); ?>');
		}
	});
}

function createFolder(folder, element) {
	var spinner = jQuery('#'+element).html("<img src='/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_ajax-loading.gif' />");
	jQuery.ajax({
		async: false,
		url: 'index.php',
		dataType: 'json',
		data: 'option=com_csvivirtuemart&view=about&task=createfolder&format=json&folder='+folder,
		success: function(data) {
			location.reload();
		},
		failure: function() {
			jQuery('#'+element).html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_CREATING_FOLDER'); ?>');
		},
		error: function() {
			jQuery('#'+element).html('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_CREATING_FOLDER'); ?>');
		}
	});
}
</script>