<?php
/**
 * Available Fields view
 *
 * Gives an overview of all available fields that can be used for import/export
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.html.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Available Fields View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewAvailableFields extends JView {
	
	/**
	 * Available fields view display method 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function display($tpl = null) {
		$mainframe = Jfactory::getApplication();
		$option	= JRequest::getCmd('option');
		
		// Load the filters
		$list['filter_order']		= $mainframe->getUserStateFromRequest('availablefields.filter_order',		'filter_order',		'',	'cmd');
		$list['filter_order_Dir']	= $mainframe->getUserStateFromRequest('availablefields.filter_order_Dir',	'filter_order_Dir',	'',	'word');
		$list['filter_state']		= $mainframe->getUserStateFromRequest('availablefields.filter_state',		'filter_state',		'',	'word');
		$list['searchtemplatetype']		= $mainframe->getUserStateFromRequest('availablefields.searchtemplatetype',	'searchtemplatetype',	'',	'word');
		
		// Get data from the model
        $pagination = $this->get('Pagination');
		
		// Get the list of available fields
		$availablefields = $this->get('Data');
		                      
		if (!$this->get('FieldCheck')) JError::raiseWarning(0, JText::_('COM_CSVIVIRTUEMART_NO_AVAILABLE_FIELDS'));
		                        
		// Get the list of template types
		$template_types = $this->get('TemplateTypes', 'templates');
		
		// Create the template list
		$list['templatetypes'] = JHTML::_('select.genericlist', $template_types, 'searchtemplatetype', '', 'value', 'name', $list['searchtemplatetype'], false, true); 
		
		// Assign the data
		$this->assignRef('availablefields', $availablefields);
		$this->assignRef('list', $list);
		$this->assignRef('pagination', $pagination);
		
		// Show the toolbar
		$this->addToolbar();
		
		// Display it all
		parent::display($tpl);
	}
	
	/**
	 * Display the toolbar 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		protected
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	protected function addToolbar() {
		JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_AVAILABLE_FIELDS'), 'csvivirtuemart_availablefields_48');
		JToolBarHelper::custom('update', 'csvivirtuemart_availablefields_32', 'csvivirtuemart_availablefields_32', JText::_('COM_CSVIVIRTUEMART_UPDATE'), false);
		JToolBarHelper::help('available_fields.html', true);
	}
}
?>