<?php
/**
 * Export page
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
JHtml::_('behavior.modal');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.calendar');
JHtml::_('behavior.keepalive');
?>
<form action="index.php" method="post" name="adminForm">
	<input type="hidden" name="option" value="com_csvivirtuemart" />
	<input type="hidden" name="task" value="exportfile" />
	<input type="hidden" name="view" value="exportfile" />
	<input type="hidden" name="from" value="export" />
	<input type="hidden" name="template_name" value="" />
	<input type="hidden" name="template_id" value="" />

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TEMPLATE_DETAILS'); ?></legend>
	<div id="template_list">
		<?php echo $this->lists['templates']; ?>
		<input type="button" onclick="submitbutton('load')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_LOAD'); ?>" class="button">
		<input type="button" onclick="submitbutton('remove')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE'); ?>" class="button">
		<input type="button" onclick="submitbutton('save')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_APPLY'); ?>" class="button">
		<input type="button" onclick="submitbutton('saveasnew')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_SAVE_AS_NEW'); ?>" class="button">
	</div>
</fieldset>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_DETAILS'); ?></legend>
	<div id="export_page">
		<ul>
			<li><a href="#export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT'); ?></a></li>
			<li><a href="#options_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_OPTIONS');?></a></li>
			<li><a href="#layout_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LAYOUT');?></a></li>
			<li><a href="#email_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_EMAIL');?></a></li>
			<li><a href="#replacement_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_REPLACEMENT');?></a></li>
			<li><a href="#shopper_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SHOPPER');?></a></li>
			<li><a href="#limit_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_LIMIT');?></a></li>
		</ul>
		<div id="export_tab">
			<?php echo $this->loadTemplate('export'); ?>
		</div>
		<div id="options_tab">
			<ul>
				<li><a href="#general_options_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_GENERAL_OPTIONS'); ?></a></li>
				<li><a href="#product_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_OPTIONS');?></a></li>
				<li><a href="#order_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_OPTIONS');?></a></li>
				<li><a href="#order_item_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_ITEM_OPTIONS');?></a></li>
				<li><a href="#multiple_prices_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MULTIPLE_PRICES_OPTIONS');?></a></li>
				<li><a href="#product_type_names_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_TYPE_NAMES_OPTIONS');?></a></li>
				<li><a href="#userinfo_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USERINFO_OPTIONS');?></a></li>
				<li><a href="#tax_export_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_TAX_OPTIONS');?></a></li>
			</ul>
			<div id="general_options_tab">
				<?php echo $this->loadTemplate('general'); ?>
			</div>
			<div id="order_export_tab">
				<?php echo $this->loadTemplate('order'); ?>
			</div>
			<div id="order_item_export_tab">
				<?php echo $this->loadTemplate('orderitem'); ?>
			</div>
			<div id="product_export_tab">
				<?php echo $this->loadTemplate('product'); ?>
			</div>
			<div id="multiple_prices_export_tab">
				<?php echo $this->loadTemplate('multipleprices'); ?>
			</div>
			<div id="product_type_names_export_tab">
				<?php echo $this->loadTemplate('producttypenames'); ?>
			</div>
			<div id="userinfo_export_tab">
				<?php echo $this->loadTemplate('userinfo'); ?>
			</div>
			<div id="tax_export_tab">
				<?php echo $this->loadTemplate('tax'); ?>
			</div>
		</div>
		<div id="layout_tab">
			<?php echo $this->loadTemplate('layout'); ?>
		</div>
		<div id="email_tab">
			<?php echo $this->loadTemplate('email'); ?>
		</div>
		<div id="replacement_tab">
			<?php echo $this->loadTemplate('replacement'); ?>
		</div>
		<div id="shopper_tab">
			<ul>
				<li><a href="#shopper_shipping_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_SHOPPER_SHIPPING_OPTIONS'); ?></a></li>
			</ul>
			<div id="shopper_shipping_tab">
				<?php echo $this->loadTemplate('shipping'); ?>
			</div>
		</div>
		<div id="limit_tab">
			<?php echo $this->loadTemplate('limit'); ?>
		</div>
	</div>
</fieldset>

<?php echo JHtml::_('form.token'); ?>
</form>
<style type="text/css">
.ui-tabs .ui-tabs-hide {
     display: none;
}
</style>
<script type="text/javascript">
jQuery(function() {
	jQuery("#export_page").tabs();
	jQuery("#fields_basic_tab").tabs();
	jQuery("#options_tab").tabs();
	jQuery("#shopper_tab").tabs();
	jQuery("#templates").tableDnD();

});

function submitbutton(pressbutton) {
	// Check if the last field is not set to combine
	if (jQuery('#fieldslist tbody tr:last td:eq(4) :checked').val() == 1) {
		jAlert('<?php echo JText::_('COM_CSVIVIRTUEMART_LAST_FIELD_COMBINE'); ?>');
		return false;
	}
	else {
		if (pressbutton == 'saveasnew') {
			jPrompt('<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ADD_TEMPLATE_NAME_DESC'); ?>', '', '<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ADD_TEMPLATE_NAME_LABEL'); ?>', function(template_name) {
				if (template_name) {	
					document.adminForm.template_name.value = template_name;
					document.adminForm.view.value = 'export';
					submitform(pressbutton);
				}
				else return false;
			});
		}
		else if (pressbutton == 'save') {
			document.adminForm.template_id.value = jQuery('#select_template :selected').val();
			document.adminForm.view.value = 'export';
			submitform(pressbutton);
		}
		else if (pressbutton == 'remove') {
			jConfirm('<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE_TEMPLATE_DESC'); ?>', '<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE_TEMPLATE_LABEL'); ?>', function(r) {
				if (r) {
					document.adminForm.template_id.value = jQuery('#select_template :selected').val();
					document.adminForm.view.value = 'export';
					submitform(pressbutton);
				}
				else return false;
			})
		}
		else if (pressbutton == 'load') {
			document.adminForm.template_id.value = jQuery('#select_template :selected').val();
			document.adminForm.view.value = 'export';
			submitform(pressbutton);
		}
		else {
			if (pressbutton == 'cronline') {
				pressbutton = 'cron';
				document.adminForm.view.value = 'cron';
				document.adminForm.view.value = 'cron';
			}
			else {
				var checkresult = checkFields();
				if (!checkresult) return false;
			}
			var template_id = jQuery('#select_template :selected').val();
			if (template_id === "") var template_name = '';
			else var template_name = jQuery('#select_template :selected').html();
			document.adminForm.template_id.value = template_id;
			document.adminForm.template_name.value = template_name;
			submitform(pressbutton);
		}
	}
}

function checkFields() {
	// Check if any fields are selected
	if (jQuery('#fieldslist tbody tr').size() == 0) {
		jAlert('<?php echo JText::_('COM_CSVIVIRTUEMART_NO_FIELDS_SELECTED'); ?>');
		return false;
	}
	else return true;
}
</script>