<?php
/**
 * Export orders
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default_order.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
		<!-- Order number -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_NUMBER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_NUMBER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_NUMBER_LABEL'); ?></span>
			</td>
			<td>
				<input type="text" name="jform[order][ordernostart]" id="ordernostart" value="<?php echo $this->template->getValue('ordernostart', 'order'); ?>" /> - <input type="text" name="jform[order][ordernoend]" id="ordernoend" value="<?php echo $this->template->getValue('ordernoend', 'order'); ?>" />
			</td>
		</tr>
		<!-- List of order numbers -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_LIST_LABEL'); ?></span>
			</td>
			<td>
				<input class="longtext" type="text" name="jform[order][orderlist]" id="orderlist" value="<?php echo $this->template->getValue('orderlist', 'order'); ?>" />
			</td>
		</tr>
		<!-- Order date -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_DATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_DATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_DATE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('calendar', $this->template->getValue('orderdatestart', 'order'), 'jform[order][orderdatestart]', 'orderdatestart', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
				 - 
				<?php echo JHTML::_('calendar', $this->template->getValue('orderdateend', 'order'), 'jform[order][orderdateend]', 'orderdateend', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
			</td>
		</tr>
		<!-- Order modified date -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_MODIFIED_DATE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_MODIFIED_DATE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_MODIFIED_DATE_LABEL'); ?></span>
			</td>
			<td>
				<?php echo JHTML::_('calendar', $this->template->getValue('ordermdatestart', 'order'), 'jform[order][ordermdatestart]', 'ordermdatestart', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
				 - 
				<?php echo JHTML::_('calendar', $this->template->getValue('ordermdateend', 'order'), 'jform[order][ordermdateend]', 'ordermdateend', '%d-%m-%Y %H:%M:%S', 'size="25"'); ?>
			</td>
		</tr>
		<!-- Order status -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_STATUS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_STATUS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_STATUS_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['orderstatus']; ?>
			</td>
		</tr>
		<!-- Order payment -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PAYMENT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PAYMENT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PAYMENT_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['orderpayment']; ?>
			</td>
		</tr>
		<!-- Shipping info -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_SHIPPING_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_SHIPPING_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_SHIPPING_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['order_address']; ?>
			</td>
		</tr>
		<!-- Order manufacturer -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MANUFACTURER_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['ordermanufacturer']; ?>
			</td>
		</tr>
		<!-- Order currency -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_CURRENCY_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_CURRENCY_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_CURRENCY_LABEL'); ?></span>
			</td>
			<td>
				<?php echo $this->lists['ordercurrency']; ?>
			</td>
		</tr>
		<!-- Order price -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRICE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRICE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRICE_LABEL'); ?></span>
			</td>
			<td>
				<input type="text" name="jform[order][orderpricestart]" id="orderpricestart" value="<?php echo $this->template->getValue('orderpricestart', 'order'); ?>" /> - <input type="text" name="jform[order][orderpriceend]" id="orderpriceend" value="<?php echo $this->template->getValue('orderpriceend', 'order'); ?>" />
			</td>
		</tr>
		<!-- Order user info -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_USER_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_USER_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_USER_LABEL'); ?></span>
			</td>
			<td>
				<div id="searchuser"><input type="text" name="searchuserbox" id="searchuserbox" value="" /></div>
				<table id="selectuserid" class="adminlist">
					<thead>
					<tr><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USER_ID'); ?></th><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USERNAME');?></th></tr>
					</thead>
				</table>
				<?php echo $this->lists['orderuser']; ?>
			</td>
		</tr>
		<!-- Order product info -->
		<tr>
			<td class="key">
				<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRODUCT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRODUCT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_ORDER_PRODUCT_LABEL'); ?></span>
			</td>
			<td>
				<div id="searchproduct"><input type="text" name="searchproductbox" id="searchproductbox" value="" /></div>
				<table id="selectproductsku" class="adminlist">
					<thead>
					<tr><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_SKU'); ?></th><th><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_PRODUCT_NAME');?></th></tr>
					</thead>
				</table>
				<?php echo $this->lists['orderproduct']; ?>
			</td>
		</tr>
		</tbody>
	</table>
</fieldset>