<?php
/**
 * Export view
 *
 * @package 	CSVIVirtuemart.export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.html.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Export View
 *
 * @package CSVIVirtuemart.export
 */
class CsvivirtuemartViewExport extends JView {

	/**
	 * Show the export screen
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.0
	 */
	public function display($tpl = null) {

		// Load the saved templates
		$template_model = $this->getModel('Templates');
		$this->lists['templates'] = JHtml::_('select.genericlist', $template_model->getTemplates('export'), 'select_template', '', 'value', 'text', JRequest::getInt('template_id'));

		// Load the selected template
		$item = $this->get('Template', 'templates');

		// Load the form handler
		$this->loadHelper('template');
		$this->template = new CsviTemplate($item);
		JRequest::setVar('template', $this->template);

		// Load the general options
		$this->getOptions();

		// Load the order fields
		$this->getOrderFields();

		// Load the order fields
		$this->getOrderItemFields();

		// Load the product fields
		$this->getProductFields();

		// Load the product type name fields
		$this->getProductTypeNameFields();

		// Load the user info fields
		$this->getUserInfoFields();

		// Load the multiple prices fields
		$this->getMultiplePricesFields();

		// Load the tax rate fields
		$this->getTaxRateFields();

		// Load the editor
		$this->editor = JFactory::getEditor();

		// Set the toolbar
		$this->setToolbar();

		// Display it all
		parent::display($tpl);
	}

	/**
	 * Set the toolbar
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		protected
	 * @param
	 * @return
	 * @since 		1.0
	 */
	protected function setToolbar() {
	 	// Toolbar title
		JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_EXPORT'), 'csvivirtuemart_export_48');

		// Toolbar buttons
		JToolBarHelper::custom('cronline', 'csvivirtuemart_cron_32', 'csvivirtuemart_cron_32', JText::_('COM_CSVIVIRTUEMART_CRONLINE'), false);
		JToolBarHelper::custom('exportfile', 'csvivirtuemart_export_32', 'csvivirtuemart_export_32', JText::_('COM_CSVIVIRTUEMART_EXPORT'), false);
		JToolBarHelper::help('export.html', true);
	}

	/**
	 * Get the general options
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getOptions() {
		$model = $this->getModel();
		// Get the export types
		$template_model = $this->getModel('templates');
		$templatetypes = $template_model->getTemplateTypes('export');
		$this->lists['export_type'] = JHtml::_('select.genericlist', $templatetypes, 'jform[export_type]', '' , 'value', 'name', $this->template->getValue('export_type'), false, true);

		// Create a place holder for the custom export tables
		$options = array();
		$this->showcustomtables = $this->template->getValue('custom_table_export', '', false);
		if ($this->showcustomtables) {
			$customtables = CsviHelper::getCustomTables();
			foreach ($customtables as $table) {
				$options[] = JHtml::_('select.option', $table, $table);
			}
		}
		$this->lists['customtables'] = JHtml::_('select.genericlist', $options, 'jform[custom_table_export]', '', 'value', 'text', $this->template->getValue('custom_table_export'));

		// Get the CSVI supported fields
		$availablefields_model = $this->getModel('availablefields');
		$tablename = ($this->showcustomtables) ? $this->showcustomtables : '';
		if (is_array($tablename)) $tablename = (string)$tablename;
		$csvisupportedfields = $availablefields_model->getAvailableFields($this->template->getValue('export_type', '', 'categorydetailsexport'), true, $tablename);
		$this->assignRef('exportfields', $csvisupportedfields);

		// Load the export fields
		$advanced_csvifields = array();
		foreach ($csvisupportedfields as $key => $fieldname) {
			$advanced_csvifields[] = JHtml::_('select.option', $fieldname, $fieldname);
		}
		$this->lists['exportfields'] = JHtml::_('select.genericlist', $advanced_csvifields, '_field_name', null, 'value', 'text', null, '_field_name');

		// Load the replacement fields
		$export_fields = $this->template->getValue('export_fields');
		$this->advanced_csvifields = array();
		$this->replacefields = array();
		if (isset($export_fields['_selected_name'])) {
			$count = count($export_fields['_selected_name']);
			for ($rows = 0; $rows < $count; $rows++) {
				$fieldname = $export_fields['_selected_name'][$rows].$export_fields['_column_header'][$rows];
				$desc = $export_fields['_selected_name'][$rows].' ('.$export_fields['_column_header'][$rows].')';
				$this->replacefields[$fieldname] = $desc;
				$this->advanced_csvifields[] = JHtml::_('select.option', $fieldname, $desc);
			}
		}
		else $this->advanced_csvifields = $advanced_csvifields;
		$this->lists['replacementfields'] = JHtml::_('select.genericlist', $this->advanced_csvifields, '_field_name_replace', null, 'value', 'text', null, '_field_name_replace');

		// Export types
		$options = array();
		$options[] = JHtml::_('select.option', 'csv', 'CSV');
		$options[] = JHtml::_('select.option', 'xml', 'XML');
		$options[] = JHtml::_('select.option', 'html', 'HTML');
		$this->lists['export_file'] = JHtml::_('select.genericlist', $options, 'jform[general][export_file]', null , 'value', 'text', $this->template->getValue('export_file', 'general', 'csv'));

		// Export sites
		$options = array();
		$options[] = JHtml::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_CHOOSE_WEBSITE'));
		$sites = $model->getExportSites($this->template->getValue('export_file', 'general', 'csv'));
		foreach ($sites as $site) {
			$options[] = JHtml::_('select.option', $site, JText::_('COM_CSVIVIRTUEMART_'.$site));
		}
		$this->lists['export_site'] = JHtml::_('select.genericlist', $options, 'jform[general][export_site]', null , 'value', 'text', $this->template->getValue('export_site', 'general'));

		// Get the VirtueMart ID's
		$vm_itemids = $this->get('VmItemids');
		if (count($vm_itemids) == 0) {
			$vm_itemids[] = JHtml::_('select.option', '1', 'DEFAULT');
		}
		if (count($vm_itemids) > 0) $selected = $vm_itemids[0]->value;
		$this->lists['vm_itemid'] = JHtml::_('select.genericlist', $vm_itemids, 'jform[general][vm_itemid]', null , 'value', 'text', $this->template->getValue('vm_itemid', 'general', $selected), false, true);

		// Export frontend
		$this->lists['export_frontend'] = JHtml::_('select.booleanlist', 'jform[general][export_frontend]', null, $this->template->getValue('export_frontend', 'general', '0'));

		// Price currency
		$this->lists['add_currency_to_price'] = JHtml::_('select.booleanlist', 'jform[general][add_currency_to_price]', null, $this->template->getValue('add_currency_to_price', 'general', '0'));

		// Published state
		$options = array();
		$options[] = JHtml::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_ALL_STATES'));
		$options[] = JHtml::_('select.option', 'Y', JText::_('COM_CSVIVIRTUEMART_PUBLISHED'));
		$options[] = JHtml::_('select.option', 'N', JText::_('COM_CSVIVIRTUEMART_UNPUBLISHED'));
		$this->lists['publish_state'] = JHTML::_('select.radiolist',  $options, 'jform[general][publish_state]', '', 'value', 'text', $this->template->getValue('publish_state', 'general'));
		$this->lists['publish_state_categories'] = JHTML::_('select.radiolist',  $options, 'jform[product][publish_state_categories]', '', 'value', 'text', $this->template->getValue('publish_state_categories', 'product'));

		// Get the price operators
		$options = array();
		$options[] = JHtml::_('select.option', 'gt', JText::_('COM_CSVIVIRTUEMART_PRICE_GREATER_THAN'));
		$options[] = JHtml::_('select.option', 'eq', JText::_('COM_CSVIVIRTUEMART_PRICE_EQUAL'));
		$options[] = JHtml::_('select.option', 'lt', JText::_('COM_CSVIVIRTUEMART_PRICE_LOWER_THAN'));
		$options[] = JHtml::_('select.option', 'bt', JText::_('COM_CSVIVIRTUEMART_PRICE_BETWEEN'));
		$this->lists['priceoperators'] = JHtml::_('select.genericlist', $options, 'jform[product][priceoperator]', null , 'value', 'text', $this->template->getValue('priceoperator', 'product', 'gt'), false, true);
	}

	/**
	 * Get all the data for the order export fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getOrderFields() {

		// Manufacturers
		$manufacturers = $this->get('Manufacturers');
		array_unshift($manufacturers, JHtml::_('select.option', 'none', 'COM_CSVIVIRTUEMART_ALL_MANUFACTURERS'));
		$size = (count($manufacturers) > 7) ? 7 : count($manufacturers);
		$this->lists['ordermanufacturer'] = JHtml::_('select.genericlist', $manufacturers, 'jform[order][manufacturer][]', 'multiple="multiple" size="'.$size.'"' , 'value', 'text', $this->template->getValue('manufacturer', 'order', 'none'), false, true);

		// Get order statusses
		$orderstatus = $this->get('OrderStatus');
		if (is_array($orderstatus)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->order_status_code = '';
			$dontuse->order_status_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($orderstatus, $dontuse);
			if (count($orderstatus) > 10) $orderstatussize = 10;
			else $orderstatussize = count($orderstatus);
			$this->lists['orderstatus'] = JHtml::_('select.genericlist', $orderstatus, 'jform[order][orderstatus][]', 'multiple size="'.$orderstatussize.'"' , 'order_status_code', 'order_status_name', $this->template->getValue('orderstatus', 'order'));
		}

		// Get order users
		$orderuser = array();
		// Load the order users already chosen
		$orderuser = $this->get('SelectedOrderUser');
		if (!is_array($orderuser)) $orderuser = (array) $orderuser;
		// Add a dont use option
		$dontuse = new StdClass();
		$dontuse->user_id = '';
		$dontuse->user_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
		array_unshift($orderuser, $dontuse);
		$this->lists['orderuser'] = JHtml::_('select.genericlist', $orderuser, 'jform[order][orderuser][]', 'multiple size="10"' , 'user_id', 'user_name', $this->template->getValue('orderuser', 'order'));

		// Get order products
		$orderproduct = array();
		// Load the order products already chosen
		$orderproduct = $this->get('SelectedOrderProduct');
		if (is_array($orderproduct)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->product_sku = '';
			$dontuse->product_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($orderproduct, $dontuse);
			$this->lists['orderproduct'] = JHtml::_('select.genericlist', $orderproduct, 'jform[order][orderproduct][]', 'multiple size="10"' , 'product_sku', 'product_name', $this->template->getValue('orderproduct', 'order', ''));
		}

		// Get order currencies
		$ordercurrency = $this->get('OrderCurrency');
		if (is_array($ordercurrency)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->order_currency = '';
			$dontuse->currency_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($ordercurrency, $dontuse);
			if (count($ordercurrency) > 10) $ordercurrencysize = 10;
			else $ordercurrencysize = count($ordercurrency);
			$this->lists['ordercurrency'] = JHtml::_('select.genericlist', $ordercurrency, 'jform[order][ordercurrency][]', 'multiple size="'.$ordercurrencysize.'"' , 'order_currency', 'currency_name', $this->template->getValue('ordercurrency', 'order'));
		}
		else $this->lists['ordercurrency'] = '';

		// Get the shipping address
		$model = $this->getModel();
		$this->lists['order_address'] = JHtml::_('select.genericlist', $model->getShippingAddress('order'), 'jform[order][order_address]', '' , 'address_code', 'address_name', $this->template->getValue('order_address', 'order'));

		// Get order payments
		$orderpayment = $this->get('PaymentMethods');
		if (is_array($orderpayment)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->payment_method_id = '';
			$dontuse->payment_method_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($orderpayment, $dontuse);
			$this->lists['orderpayment'] = JHtml::_('select.genericlist', $orderpayment, 'jform[order][orderpayment][]', 'multiple size="5"' , 'payment_method_id', 'payment_method_name', $this->template->getValue('orderpayment', 'order'));
		}
	}

	/**
	 * Method Description
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getOrderItemFields() {
		// Get order statusses
		$orderstatus = $this->get('OrderStatus');
		if (is_array($orderstatus)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->order_status_code = '';
			$dontuse->order_status_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($orderstatus, $dontuse);
			if (count($orderstatus) > 10) $orderstatussize = 10;
			else $orderstatussize = count($orderstatus);
			$this->lists['orderitemstatus'] = JHtml::_('select.genericlist', $orderstatus, 'jform[orderitem][orderitemstatus][]', 'multiple size="'.$orderstatussize.'"' , 'order_status_code', 'order_status_name', $this->template->getValue('orderitemstatus', 'orderitem'));
		}

		// Get order item products
		$orderproduct = array();
		// Load the order products already chosen
		$orderproduct = $this->get('SelectedOrderItemProduct');
		if (is_array($orderproduct)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->product_sku = '';
			$dontuse->product_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($orderproduct, $dontuse);
			$this->lists['orderitemproduct'] = JHtml::_('select.genericlist', $orderproduct, 'jform[orderitem][orderitemproduct][]', 'multiple size="10"' , 'product_sku', 'product_name', $this->template->getValue('orderitemproduct', 'orderitem'));
		}

		// Get order currencies
		$ordercurrency = $this->get('OrderCurrency');
		if (is_array($ordercurrency)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->order_currency = '';
			$dontuse->currency_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($ordercurrency, $dontuse);
			if (count($ordercurrency) > 10) $ordercurrencysize = 10;
			else $ordercurrencysize = count($ordercurrency);
			$this->lists['orderitemcurrency'] = JHtml::_('select.genericlist', $ordercurrency, 'jform[orderitem][orderitemcurrency][]', 'multiple size="'.$ordercurrencysize.'"' , 'order_currency', 'currency_name', $this->template->getValue('orderitemcurrency', 'orderitem'));
		}
		else $this->lists['orderitemcurrency'] = '';
	}

	/**
	 * Load the product fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getProductFields() {
	 	// Get the product categories
	 	$categories = $this->get('ProductCategories');
	 	if (count($categories) > 10) $categoriessize = 10;
		else $categoriessize = count($categories);
		$this->lists['product_categories'] = JHtml::_('select.genericlist', $categories, 'jform[product][productcategories][]', 'multiple size="'.$categoriessize.'"' , 'value', 'text', $this->template->getValue('productcategories', 'product'));

		// Shopper group name
		$shoppergroups = $this->get('ShopperGroups');
		array_unshift($shoppergroups, JHtml::_('select.option', 'none', 'COM_CSVIVIRTUEMART_ALL_SHOPPERGROUPS'));
		$size = (count($shoppergroups) > 7) ? 7 : count($shoppergroups);
		$this->lists['shopper_groups'] = JHtml::_('select.genericlist', $shoppergroups, 'jform[product][shopper_group_id][]', 'multiple="multiple" size="'.$size.'"' , 'value', 'text', $this->template->getValue('shopper_group_id', 'product', 'none'), false, true);

		// Manufacturers
		$manufacturers = $this->get('Manufacturers');
		array_unshift($manufacturers, JHtml::_('select.option', 'none', 'COM_CSVIVIRTUEMART_ALL_MANUFACTURERS'));
		$size = (count($manufacturers) > 7) ? 7 : count($manufacturers);
		$this->lists['manufacturers'] = JHtml::_('select.genericlist', $manufacturers, 'jform[product][manufacturers][]', 'multiple="multiple" size="'.$size.'"' , 'value', 'text', $this->template->getValue('manufacturers', 'product', 'none'), false, true);

		// Get the exchange rates
		$exchangerate = $this->get('ExchangeRateCurrency');
		if (is_array($exchangerate)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->currency_code = '';
			$dontuse->currency_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($exchangerate, $dontuse);
			if (count($exchangerate) > 10) $exchangeratesize = 10;
			else $exchangeratesize = count($exchangerate);
			$this->lists['targetcurrency'] = JHtml::_('select.genericlist', $exchangerate, 'jform[product][targetcurrency]', 'size="'.$exchangeratesize.'"' , 'currency_code', 'currency_name', $this->template->getValue('targetcurrency', 'product'));
		}

		// JoomFish languages
		$languages = $this->get('JoomFishLanguages');
		if (empty($languages)) $this->lists['joomfish_language'] = JText::_('COM_CSVIVIRTUEMART_NO_LANGUAGES_FOUND');
		else $this->lists['joomfish_language'] = JHtml::_('select.genericlist', $languages, 'jform[product][joomfish_language]', '' , 'value', 'text', $this->template->getValue('joomfish_language', 'product'));
	}

	/**
	 * Load the product type name fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since		3.0
	 */
	private function getProductTypeNameFields() {
		// Get the product type names
		$producttypenames = $this->get('ProductTypeNames');

		if (is_array($producttypenames) && !empty($producttypenames)) {
			$this->lists['producttypenames'] = JHtml::_('select.genericlist', $producttypenames, 'jform[producttypename][producttypenames]', '' , 'product_type_id', 'product_type_name', $this->template->getValue('producttypenames', 'producttypename'));
		}
		else $this->lists['producttypenames'] = JText::_('COM_CSVIVIRTUEMART_NO_PRODUCT_TYPE_NAMES_FOUND');
	}

	/**
	 * Load the user info fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getUserInfoFields() {
		// Get the vendors
		$vendors = $this->get('Vendors');
		if (is_array($vendors)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->vendor_id = '';
			$dontuse->vendor_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($vendors, $dontuse);
			if (count($vendors) > 10) $vendorssize = 10;
			else $vendorssize = count($vendors);
			$this->lists['userinfo_vendors'] = JHtml::_('select.genericlist', $vendors, 'jform[userinfo][vendors][]', 'multiple size="'.$vendorssize.'"' , 'vendor_id', 'vendor_name', $this->template->getValue('vendors', 'userinfo'));
		}

		// Get the permissions
		$permissions = $this->get('Permissions');
		if (is_array($permissions)) {
			// Add a dont use option
			$dontuse = new StdClass();
			$dontuse->group_id = '';
			$dontuse->group_name = JText::_('COM_CSVIVIRTUEMART_EXPORT_DONT_USE');
			array_unshift($permissions, $dontuse);
			if (count($permissions) > 10) $permissionssize = 10;
			else $permissionssize = count($permissions);
			$this->lists['userinfo_permissions'] = JHtml::_('select.genericlist', $permissions, 'jform[userinfo][permissions][]', 'multiple size="'.$permissionssize.'"' , 'group_id', 'group_name', $this->template->getValue('permissions', 'userinfo'));
		}

		// Get the shipping addresses
		$model = $this->getModel();
		$this->lists['userinfo_address'] = JHtml::_('select.genericlist', $model->getShippingAddress('userinfo'), 'jform[userinfo][userinfo_address]', '' , 'address_code', 'address_name', $this->template->getValue('userinfo_address', 'userinfo'));
	}

	/**
	 * Load the multiple prices fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.0
	 */
	private function getMultiplePricesFields() {
		// Shopper group name
		$shoppergroups = $this->get('ShopperGroups');
		array_unshift($shoppergroups, JHtml::_('select.option', 'none', 'COM_CSVIVIRTUEMART_ALL_SHOPPERGROUPS'));
		$size = (count($shoppergroups) > 7) ? 7 : count($shoppergroups);
		$this->lists['multiple_prices_shopper_groups'] = JHtml::_('select.genericlist', $shoppergroups, 'jform[multipleprices][shopper_group_id][]', 'multiple="multiple" size="'.$size.'"' , 'value', 'text', $this->template->getValue('shopper_group_id', 'multipleprices', 'none'), false, true);
	}

	/**
	 * Load the tax rate fields
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		private
	 * @param
	 * @return 		void
	 * @since 		3.1
	 */
	private function getTaxRateFields() {
		// Country filter
		$countries = $this->get('Countries');
		array_unshift($countries, JHtml::_('select.option', '', 'COM_CSVIVIRTUEMART_ALL_TAX_COUNTRIES'));
		$this->lists['tax_country'] = JHtml::_('select.genericlist', $countries, 'jform[tax][countries]', '' , 'value', 'text', $this->template->getValue('countries', 'tax', 'none'), false, true);

		// State filter
		$states = array();
		array_unshift($states, JHtml::_('select.option', 'none', JText::_('COM_CSVIVIRTUEMART_ALL_TAX_STATES')));
		$this->lists['tax_state'] = JHtml::_('select.genericlist', $states, 'jform[tax][states][]', 'multiple="multiple" size="7"', 'value', 'text', 'none');
	}
}
?>