<?php
/**
 * Import view
 *
 * @package CSVIVirtueMart
 * @author Roland Dalmulder
 * @link http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version $Id: view.json.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
* Import View
*
* @package CSVIVirtueMart
 */
class CsvivirtuemartViewExport extends JView {
	
	/**
	* Templates view display method
	* @return void
	* */
	function display($tpl = null) {
		switch (JRequest::getVar('task')) {
			case 'getuser':
				$users = $this->get('OrderUser');
				echo json_encode($users);
				break;
			case 'getproduct':
				$products = $this->get('OrderProduct');
				echo json_encode($products);
				break;
			case 'getitemproduct':
				$products = $this->get('OrderItemProduct');
				echo json_encode($products);
				break;
			case 'loadfields':
				$availablefields_model = $this->getModel('availablefields');
				$result = $availablefields_model->GetAvailableFields(JRequest::getWord('template_type'), true, JRequest::getWord('table_name', ''));
				echo json_encode($result);
				break;
			case 'loadtables':
				$result = CsviHelper::getCustomTables();
				array_unshift($result, JText::_('COM_CSVIVIRTUEMART_SELECT_TABLE_FOR_EXPORT'));
				echo json_encode($result);
				break;
			case 'loadsites':
				$model = $this->getModel();
				$options = array();
				$options[] = JHtml::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_CHOOSE_WEBSITE'));
				$sites = $model->getExportSites(JRequest::getCmd('exportsite'));
				foreach ($sites as $site) {
					$options[] = JHtml::_('select.option', $site, JText::_('COM_CSVIVIRTUEMART_'.strtoupper($site)));
				}
				echo json_encode(JHtml::_('select.genericlist', $options, 'jform[general][export_site]'));
				break;
			case 'getstates':
				$model = $this->getModel();
				$options = array();
				$options[] = JHtml::_('select.option', 'none', JText::_('COM_CSVIVIRTUEMART_ALL_TAX_STATES'));
				$states = array_merge($options, $model->getStates(JRequest::getCmd('country')));
				echo json_encode(JHtml::_('select.genericlist', $states, 'jform[tax][states][]', 'multiple="multiple" size="7"', 'value', 'text', 'none'));
				break;
			default:
				break;
		}
	}
}
?>