<?php
/**
 * Export file
 *
 * @package CSVIVirtueMart
 * @subpackage Export
 * @author Roland Dalmulder
 * @link http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version $Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
$app = JFactory::getApplication();
?>
<table id="importlog" class="adminlist">
	<thead>
		<tr>
			<th colspan="4" class="message"><?php echo JText::sprintf('COM_CSVIVIRTUEMART_RESULTS_FOR', $app->getUserState('com_csvivirtuemart.export.filename')); ?></th>
		</tr>
		<tr>
			<th class="title" width="5%">
			<?php echo JText::_('COM_CSVIVIRTUEMART_TOTAL'); ?>
			</th>
			<th class="title">
			<?php echo JText::_('COM_CSVIVIRTUEMART_RESULT'); ?>
			</th>
			<th class="title">
			<?php echo JText::_('COM_CSVIVIRTUEMART_STATUS'); ?>
			</th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="3">
				<?php
				// Show debug log
				echo JHTML::_('link', JRoute::_('index2.php?option=com_csvivirtuemart&view=logdetails&run_id='.$this->run_id), JText::_('COM_CSVIVIRTUEMART_SHOW_FULL_LOG'));
				echo ' | ';
				// Show view debug log
				if (!empty($this->logresult['debugview'])) {
					echo $this->logresult['debugview'];
					echo ' | ';
				}
				// Show download debug log
				echo $this->logresult['debug'];
				?>
			</td>
		</tr>
	</tfoot>
	<tbody>
	<?php
	if (count($this->logresult['result']) > 0) {
		foreach ($this->logresult['result'] as $result => $log) { ?>
			<tr>
				<td align="center">
					<?php echo $log->total_result; ?>
				</td>
				<td>
					<?php echo $log->result; ?>
				</td>
				<td>
					<?php echo JText::_('COM_CSVIVIRTUEMART_'.$log->status); ?>
				</td>
			</tr>
		<?php }
	}
	else { ?>
		<tr><td colspan="3"><?php echo JText::_('COM_CSVIVIRTUEMART_NO_RESULTS_FOUND'); ?></td></tr>
	<?php } ?>
	</tbody>
</table>
<script type="text/javascript">
	UpdateRowClass('exportlog');
</script>