<?php
/**
 * Import page
 *
 * @package		CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
JHtml::_('behavior.modal');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.keepalive');
?>
<form action="index.php" method="post" name="adminForm" enctype="multipart/form-data">
	<input type="hidden" name="option" value="com_csvivirtuemart" />
	<input type="hidden" name="task" value="importfile" />
	<input type="hidden" name="view" value="importfile" />
	<input type="hidden" name="from" value="import" />
	<input type="hidden" name="template_name" value="" />
	<input type="hidden" name="template_id" value="" />

<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_TEMPLATE_DETAILS'); ?></legend>
	<div id="template_list">
		<?php echo $this->lists['templates']; ?>
		<input type="button" onclick="submitbutton('load')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_LOAD'); ?>" class="button">
		<input type="button" onclick="submitbutton('remove')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE'); ?>" class="button">
		<input type="button" onclick="submitbutton('save')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_APPLY'); ?>" class="button">
		<input type="button" onclick="submitbutton('saveasnew')" value="<?php echo JText::_('COM_CSVIVIRTUEMART_SAVE_AS_NEW'); ?>" class="button">
	</div>
</fieldset>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_DETAILS'); ?></legend>
	<div id="import_page">
		<ul>
			<li><a href="#import_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT'); ?></a></li>
			<li><a href="#options_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_OPTIONS');?></a></li>
			<li><a href="#image_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_IMAGE');?></a></li>
			<li><a href="#path_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_PATH');?></a></li>
			<li><a href="#replacement_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_REPLACEMENT');?></a></li>
			<li><a href="#limit_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_LIMIT');?></a></li>
		</ul>
		<div id="import_tab">
			<?php echo $this->loadTemplate('import'); ?>
		</div>
		<div id="options_tab">
			<ul>
				<li><a href="#general_options_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_GENERAL_OPTIONS'); ?></a></li>
				<li><a href="#product_import_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_PRODUCT_OPTIONS');?></a></li>
				<li><a href="#product_files_import_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_PRODUCT_FILES_OPTIONS');?></a></li>
				<li><a href="#category_import_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_CATEGORY_OPTIONS');?></a></li>
				<li><a href="#tax_import_tab"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_TAX_OPTIONS');?></a></li>
			</ul>
			<div id="general_options_tab">
				<?php echo $this->loadTemplate('general'); ?>
			</div>
			<div id="product_import_tab">
				<?php echo $this->loadTemplate('product');
				?>
			</div>
			<div id="product_files_import_tab">
				<?php echo $this->loadTemplate('product_files');
				?>
			</div>
			<div id="category_import_tab">
				<?php echo $this->loadTemplate('category');
				?>
			</div>
			<div id="tax_import_tab">
				<?php echo $this->loadTemplate('tax');
				?>
			</div>
		</div>
		<div id="image_tab">
			<?php echo $this->loadTemplate('image'); ?>
		</div>
		<div id="path_tab">
			<?php echo $this->loadTemplate('path'); ?>
		</div>
		<div id="replacement_tab">
			<?php echo $this->loadTemplate('replacement'); ?>
		</div>
		<div id="limit_tab">
			<?php echo $this->loadTemplate('limit'); ?>
		</div>
	</div>
</fieldset>

<?php echo JHtml::_('form.token'); ?>
</form>
<style type="text/css">
.ui-tabs .ui-tabs-hide {
     display: none;
}
</style>
<script type="text/javascript">
jQuery(function() {
	jQuery("#import_page").tabs();
	jQuery("#options_tab").tabs();
	jQuery("#templates").tableDnD();

});

jQuery('#advanced1_name_tab, #advanced2_name_tab').bind('click', function() {
	jQuery('#selected_import').html(jQuery(this).html());
	if (jQuery(this).attr('id') == 'advanced1_name_tab') {
		jQuery('#import_type').attr('value', 'basic');
	}
	else if (jQuery(this).attr('id') == 'advanced2_name_tab') {
		jQuery('#import_type').attr('value', 'advanced');
	}
})

function submitbutton(pressbutton) {
	if (pressbutton == 'saveasnew') {
		jPrompt('<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_ADD_TEMPLATE_NAME_DESC'); ?>', '', '<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_ADD_TEMPLATE_NAME_LABEL'); ?>', function(template_name) {
			if (template_name) {
				document.adminForm.template_name.value = template_name;
				document.adminForm.view.value = 'import';
				submitform(pressbutton);
			}
			else return false;
		});
	}
	else if (pressbutton == 'save') {
		document.adminForm.template_id.value = jQuery('#select_template :selected').val();
		document.adminForm.view.value = 'import';
		submitform(pressbutton);
	}
	else if (pressbutton == 'remove') {
		jConfirm('<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE_TEMPLATE_DESC'); ?>', '<?php echo JText::_('COM_CSVIVIRTUEMART_REMOVE_TEMPLATE_LABEL'); ?>', function(r) {
			if (r) {
				document.adminForm.template_id.value = jQuery('#select_template :selected').val();
				document.adminForm.view.value = 'import';
				submitform(pressbutton);
			}
			else return false;
		})
	}
	else if (pressbutton == 'load') {
		document.adminForm.template_id.value = jQuery('#select_template :selected').val();
		document.adminForm.view.value = 'import';
		submitform(pressbutton);
	}
	else {
		if (pressbutton == 'cronline') {
			pressbutton = 'cron';
			document.adminForm.view.value = 'cron';
		}
		else {
			checkFields();
		}
		var template_id  = jQuery('#select_template :selected').val();
		if (template_id === "") var template_name = '';
		else var template_name = jQuery('#select_template :selected').html();
		document.adminForm.template_id.value = template_id;
		document.adminForm.template_name.value = template_name;
		submitform(pressbutton);
	}
}

function checkFields() {
	// Check if any fields are selected
	if (jQuery('#import_type').val() == 'basic') {
		if (jQuery('#jformbasic_import_fields :selected').size() == 0) {
			jAlert('<?php echo JText::_('COM_CSVIVIRTUEMART_NO_FIELDS_SELECTED'); ?>');
			return false;
		}
	}
	else if (jQuery('#import_type').val() == 'advanced') {
		if (jQuery('#fieldslist tbody tr').size() == 0) {
			jAlert('<?php echo JText::_('COM_CSVIVIRTUEMART_NO_FIELDS_SELECTED'); ?>');
			return false;
		}
	}
}
</script>