<?php
/**
 * Import page
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default_import.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_TYPE'); ?></legend>
	<div id="importtypes"><?php echo $this->lists['import_type']; ?></div>
	<div id="quickadd-buttons">
		<input class="quickadd-button" type="button" id="quickadd-button" value="<?php echo JText::_('COM_CSVIVIRTUEMART_QUICK_ADD_FIELDS'); ?>">
	</div>
</fieldset> 
<fieldset class="adminform" id="field_customtables">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_CUSTOM_TABLE_IMPORT'); ?></legend>
	<?php echo $this->lists['customtables']; ?>
</fieldset>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_SELECT_IMPORT_FIELDS'); ?></legend>
	<div id="import_fields">
		<table id="newfieldlist" class="adminlist">
			<thead>
				<tr>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_ADD_FIELD'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_NAME'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT_VALUE'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_PROCESS_FIELD'); ?></th>
					<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_COMBINE_FIELD'); ?></th>
			</thead>
			<tfoot>
				<tr>
					<td colspan="5" />
				</tr>
			</tfoot>
			<tbody>
				<tr>
					<!-- Add field -->
					<td class="center">
						<?php echo JHTML::_('link', '#', JHTML::_('image', JURI::root().'administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_add_16.png', JText::_('COM_CSVIVIRTUEMART_ADD')), array('id' => 'addRow')); ?>
					</td>
					<!-- Field name -->
					<td>
						<?php echo $this->lists['importfields']; ?>
					</td>
					<!-- Default value -->
					<td id="newfield_defaultvalue">
						<input type="text" name="_default_value" id="_default_value" value="" size="55" />
					</td>
					<!-- Process field -->
					<td id="newfield_processfield">
						<?php echo JHtml::_('select.booleanlist', '_process_field', '', '1'); ?>
					</td>
					<!-- Combine field -->
					<td id="newfield_combinefield">
						<?php echo JHtml::_('select.booleanlist', '_combine_field', '', '0'); ?>
					</td>
				</tr>
			</tbody>
		</table>
		<br />
		<table id="fieldslist" class="adminlist">
			<thead>
			<tr class="nodrag">
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_FIELD_NAME'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT_VALUE'); ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_PROCESS_FIELD') ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_COMBINE_FIELD') ?></th>
				<th class="title"><?php echo JText::_('COM_CSVIVIRTUEMART_DELETE'); ?></th>
			</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="5"></td>
				</tr>
			</tfoot>
			<tbody>
				<?php
					$import_fields = $this->template->getValue('import_fields');
					if (isset($import_fields['_selected_name'])) {
						for ($rows = 0; $rows < count($import_fields['_selected_name']); $rows++) {
							$id = mt_rand();
							?>
							<tr>
							<td><input type="text" name="jform[import_fields][_selected_name][]" value="<?php echo $import_fields['_selected_name'][$rows]; ?>" readonly="readonly" size="35" /></td>
							<td><input type="text" name="jform[import_fields][_default_value][]" value="<?php echo $import_fields['_default_value'][$rows]; ?>" size="75"/></td>
							<td><?php echo JHtml::_('select.booleanlist', 'jform[import_fields][_process_field]['.$rows.']', '', $import_fields['_process_field'][$rows], 'yes', 'no', '_process_field'.$id); ?></td>
							<td><?php if (!array_key_exists('_combine_field', $import_fields)) $import_fields['_combine_field'] = 0; echo JHtml::_('select.booleanlist', 'jform[import_fields][_combine_field]['.$rows.']', '', $import_fields['_combine_field'][$rows], 'yes', 'no', '_combine_field'.$id); ?></td>
							<td class="center"><?php echo JHtml::_('link', 'index.php?option=com_csvivirtuemart&view=import', JHtml::_('image', JURI::root().'/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_delete_32.png', 'width="20" height="20" border="0" alt="'.JText::_('COM_CSVIVIRTUEMART_DELETE').'"'), 'onclick="jQuery(this).parents(\'tr\').remove(); jQuery(\'#fieldslist\').tableDnD(); return false;"'); ?></td>
							</tr>
							<?php
						}
					}
				?>
			</tbody>
		</table>
	</div>
</fieldset>

<!-- The Quick Add form -->
<div id="quickadd-form" title="<?php echo JText::_('COM_CSVIVIRTUEMART_QUICK_ADD_FIELDS'); ?>">
	<fieldset>
	<table class="adminlist" id="quickadd-table">
		<tbody>
			<?php
			foreach ($this->importfields as $fieldname) {
				?><tr><td><input type="checkbox" name="quickfields" value="<?php echo $fieldname; ?>" /></td><td class="addfield"><?php echo $fieldname; ?></td></tr><?php
			}
			?>
		</tbody>
	</table>
	</fieldset>
</div>

<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery('#field_customtables').<?php if ($this->showcustomtables) { echo 'show()'; } else  { echo 'hide()'; } ?>;
    jQuery('#fieldslist').tableDnD();
});

// Add new field to fields list
jQuery("#addRow").click(function() {
	var remove_image 	= '<img src="<?php echo JURI::root().'/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_delete_32.png'; ?>" width="20" height="20" border="0" alt="<?php echo JText::_('COM_CSVIVIRTUEMART_DELETE'); ?>" />';
	var remove_link 	= '<a href="index.php?option=com_csvivirtuemart&view=export" onclick="jQuery(this).parents(\'tr\').remove(); jQuery(\'#fieldslist\').tableDnD(); return false;">'+remove_image+'</a>';
	var field_name	 	= '<input type="text" name="jform[import_fields][_selected_name][]" value="'+jQuery('#_field_name').val()+'" readonly="readonly" size="35" />';
	var default_value	= '<input type="text" name="jform[import_fields][_default_value][]" value="'+jQuery('#_default_value').val()+'" size="75"/>';
	var rows = jQuery("#fieldslist tbody").children().size();
	if (jQuery("#newfield_processfield input[@name='_process_field']:checked").val() == 1) {
		var process_link		= '<input type="radio" value="0" id="_process_field'+rows+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" checked="checked" value="1" id="_process_field'+(rows+1)+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?></label>';
	}
	else {
		var process_link		= '<input type="radio" checked="checked" value="0" id="_process_field'+rows+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" value="1" id="_process_field'+(rows+1)+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?></label>';
	}
	if (jQuery("#newfield_combinefield input[@name='_combine_field']:checked").val() == 1) {
		var combine_link		= '<input type="radio" value="0" id="_combine_field'+rows+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" checked="checked" value="1" id="_combine_field'+(rows+1)+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?><m/label>';
	}
	else {
		var combine_link		= '<input type="radio" checked="checked" value="0" id="_combine_field'+rows+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" value="1" id="_combine_field'+(rows+1)+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?></label>';
	}
	addTableRow(field_name, default_value, process_link, combine_link, remove_link);
	return false;
});

jQuery('#jformimport_type').live('change', function() {
	var template_type = jQuery(this).val();
	if (template_type == 'customimport') {
		jQuery('#field_customtables').show();
		getData('loadtables');
	}
	else {
		jQuery('#field_customtables').hide();
		getData('loadfields');
	}
})

jQuery('#jformcustom_table_import').live('change', function() {
	if (jQuery(this).val() != '') {
		getData('loadfields');
	}
});

function getData(task) {
	var template_type = jQuery('#jformimport_type').val();
	var table_name = jQuery('#jformcustom_table_import').val();
	jQuery.ajax({
			async: false,
			url: 'index.php',
			dataType: 'json',
			data: 'option=com_csvivirtuemart&view=export&task='+task+'&format=json&template_type='+template_type+'&table_name='+table_name,
			success: function(data) {
				switch (task) {
					case 'loadtables':
						loadTables(data);
						break;
					case 'loadfields':
						loadFields(data);
						break;
				}
			},
			error:function (xhr, ajaxOptions, thrownError){
				jAlert(thrownError);
            }  
	});
}

function loadTables(data) {
	if (data) {
		var optionsValues = '<select id="jformcustom_table_import" name="jform[custom_table_import]">';
		for (var i = 0; i < data.length; i++) {
				optionsValues += '<option value="' + data[i] + '">' + data[i] + '</option>';
		};
		optionsValues += '</select>';
		jQuery('#jformcustom_table_import').replaceWith(optionsValues);
	}
}
function loadFields(data) {
	if (data) {
		if (data.length > 0) {
			var optionsValues = '';
			var trValues = '';
			for (var i = 0; i < data.length; i++) {
					optionsValues += '<option value="' + data[i] + '">' + data[i] + '</option>';
					trValues += '<tr><td><input type="checkbox" name="quickfields" value="' + data[i] + '" /></td><td class="addfield">' + data[i] + '</td></tr>';
			};
			jQuery('#_field_name').replaceWith('<select id="_field_name" name="field[_field_name]">'+optionsValues+'</select>');
			jQuery('#fieldslist tbody').children().remove();
			jQuery('#_field_name_replace').replaceWith('<select id="_field_name_replace" name="_field_name_replace">'+optionsValues+'</select>');
			jQuery('#fieldslist_replace tbody').children().remove();
			jQuery('#quickadd-table tbody').replaceWith('<tbody>'+trValues+'</tbody>');
		}
	};
}

/**
 * Method Description 
 * 
 * @copyright 
 * @author 
 * @todo 		Check jQuery when maxHeight function works !!
 * @see 
 * @access 
 * @param 
 * @return 
 * @since 
 */
 jQuery(function() {
		jQuery("#quickadd-form").dialog({
			autoOpen: false,
			height: 600,
			width: 350,
			modal: true,
			buttons: {
				"<?php echo JText::_('COM_CSVIVIRTUEMART_ADD_FIELDS'); ?>": function() {
					var default_value	= '<input type="text" name="jform[import_fields][_default_value][]" value="" size="75"/>';
					var remove_image 	= '<img src="<?php echo JURI::root().'/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_delete_32.png'; ?>" width="20" height="20" border="0" alt="<?php echo JText::_('COM_CSVIVIRTUEMART_DELETE'); ?>" />';
					var remove_link 	= '<a href="index.php?option=com_csvivirtuemart&view=export" onclick="jQuery(this).parents(\'tr\').remove(); jQuery(\'#fieldslist\').tableDnD(); return false;">'+remove_image+'</a>';
					jQuery("input[@name='quickfields'][type='checkbox']").each(function() {
						if (jQuery(this).is(':checked')) {
							var field_name = '<input type="text" name="jform[import_fields][_selected_name][]" value="'+jQuery(this).val()+'" readonly="readonly" size="35" />';
							var rows = jQuery("#fieldslist tbody").children().size();
							var process_link = '<input type="radio" value="0" id="_process_field'+rows+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" checked="checked" value="1" id="_process_field'+(rows+1)+'" name="jform[import_fields][_process_field]['+rows+']"><label for="_process_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?></label>';
							var combine_link = '<input type="radio" value="0" checked="checked" id="_combine_field'+rows+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+rows+'"> <?php echo JText::_('NO'); ?></label> <input type="radio" value="1" id="_combine_field'+(rows+1)+'" name="jform[import_fields][_combine_field]['+rows+']"><label for="_combine_field'+(rows+1)+'"> <?php echo JText::_('YES'); ?></label>';
							addTableRow(field_name, default_value, process_link, combine_link, remove_link);
							jQuery(this).attr('checked', false);
						}
					});
					jQuery(this).dialog("close");
				},
				Cancel: function() {
					jQuery(this).dialog("close");
				}
			},
			close: function() {
				
			}
		});

		jQuery( "#quickadd-button" )
			.click(function() {
				jQuery( "#quickadd-form" ).dialog( "open" );
			});
		
});

// Selects a field in the quick add list when user clicks on the name only
jQuery("addfield").click(function() {
	var selectbox = jQuery(this).parent().children('td').children('input');
	if (jQuery(selectbox).attr('checked')) {
		jQuery(selectbox).attr('checked', false);
	}
	else {
		jQuery(selectbox).attr('checked', true);
	}
});
 
function addTableRow(field_name, default_value, process_link, combine_link, remove_link) {
	var tr = '<tr><td>'+field_name+'</td><td>'+default_value+'</td><td>'+process_link+'</td><td>'+combine_link+'</td><td class="center">'+remove_link+'</td></tr>';
	var table = jQuery("#fieldslist");
	var tableBody = jQuery("tbody", table);
	newRow = jQuery(tr).appendTo(tableBody);
	jQuery("#fieldslist").tableDnD();
}
</script>