<?php
/**
 * Import system limit options
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default_limit.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_LIMIT_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Use system limits -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_USE_SYSTEM_LIMITS_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[limit][use_system_limits]', '', $this->template->getValue('use_system_limits', 'limit')); ?>
				</td>
			</tr>
			<!-- Maximum execution time -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MAX_EXECUTION_TIME_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="max_execution_time" name="jform[limit][max_execution_time]" value="<?php echo $this->template->getValue('max_execution_time', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('max_execution_time')); ?>
				</td>
			</tr>
			<!-- Maximum memory -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_EXPORT_MEMORY_LIMIT_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="memory_limit" name="jform[limit][memory_limit]" value="<?php echo $this->template->getValue('memory_limit', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('memory_limit')); ?>
				</td>
			</tr>
			
			<!-- Maximum POST size -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_POST_MAX_SIZE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_POST_MAX_SIZE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_POST_MAX_SIZE_LABEL'); ?></span>
				</td>
				<td>
					<input class="template_input" type="text" id="post_max_size" name="jform[limit][post_max_size]" value="<?php echo $this->template->getValue('post_max_size', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('post_max_size')); ?>
				</td>
			</tr>
			
			<!-- Maximum Upload size -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_MAX_FILESIZE_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_MAX_FILESIZE_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_UPLOAD_MAX_FILESIZE_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="upload_max_filesize" name="jform[limit][upload_max_filesize]" value="<?php echo $this->template->getValue('upload_max_filesize', 'limit');?>"><br />
					<?php echo JText::_('COM_CSVIVIRTUEMART_DEFAULT'); ?>: <?php echo intval(ini_get('upload_max_filesize')); ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
