<?php
/**
 * Import product options
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Import
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default_product.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<fieldset class="adminform">
	<legend><?php echo JText::_('COM_CSVIVIRTUEMART_IMPORT_PRODUCT_OPTIONS'); ?></legend>
	<table class="admintable">
		<tbody>
			<!-- Update products based on -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_UPDATE_BASED_ON_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_UPDATE_BASED_ON_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_UPDATE_BASED_ON_LABEL'); ?></span>
				</td>
				<td>
					<?php echo $this->lists['update_based_on']; ?>
				</td>
			</tr>
			<!-- MPN column name -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_MPN_COLUMN_NAME_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_MPN_COLUMN_NAME_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_MPN_COLUMN_NAME_LABEL'); ?></span>
				</td>
				<td>
					<input type="text" id="mpn_column_name" name="jform[product][mpn_column_name]" value="<?php echo $this->template->getValue('mpn_column_name', 'product', ''); ?>">
				</td>
			</tr>
			<!-- Unpublish before import -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_UNPUBLISH_BEFORE_IMPORT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_UNPUBLISH_BEFORE_IMPORT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_UNPUBLISH_BEFORE_IMPORT_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][unpublish_before_import]', '', $this->template->getValue('unpublish_before_import', 'product', 0)); ?>
				</td>
			</tr>
			<!-- Use ICEcat data -->
			<tr>
				<td class="key">
					<span class="hasTip" title="<?php echo JText::_('COM_CSVIVIRTUEMART_USE_ICECAT_LABEL'); ?> :: <?php echo JText::_('COM_CSVIVIRTUEMART_USE_ICECAT_DESC'); ?>"><?php echo JText::_('COM_CSVIVIRTUEMART_USE_ICECAT_LABEL'); ?></span>
				</td>
				<td>
					<?php echo JHTML::_('select.booleanlist', 'jform[product][use_icecat]', '', $this->template->getValue('use_icecat', 'product', 0)); ?>
				</td>
			</tr>
		</tbody>
	</table>
</fieldset>
<script type="text/javascript">
jQuery(document).ready(function() {
	if ('<?php echo $this->template->getValue('update_based_on', 'product', 'product_sku'); ?>' != 'product_mpn') {
		jQuery('#mpn_column_name').attr("disabled", true);
	}
});
jQuery('#jformproductupdate_based_on').live('click', function() {
	if (jQuery(this).val() == 'product_mpn') {
		jQuery('#mpn_column_name').attr("disabled", false);
	}
	else jQuery('#mpn_column_name').attr("disabled", true);
});
</script>
