<?php
/**
 * Import results view
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.result.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Import results view
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewImport extends JView {
	
	/**
	 * Templates view display method
	 * @return void
	 */
	function display($tpl = null) {
		// Load the settings
		$settings_model = new CsvivirtuemartModelSettings();
		
		if ($settings_model->getSetting('log_store', 1)) {
			// Load the results from the log
			$logresult = $this->get('Stats', 'log');
		}
		else $logresult = false;
		$this->assignRef('logresult', $logresult);
		
		// Get the run time
		$session = JFactory::getSession();
		$option = JRequest::getVar('option');
		$runtime = time()-$session->get($option.'.runtime');
		$this->assignRef('runtime', JText::sprintf('COM_CSVIVIRTUEMART_RUNTIME_IMPORT', number_format($runtime/60, 2), $runtime));
		
		// Get the toolbar title
		JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_IMPORT_RESULT'), 'csvivirtuemart_import_48');
		
		// Display it all
		parent::display($tpl);
	}
}
?>
