<?php
/**
 * Import file cron view
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.json.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Import file View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewImportFile extends JView {

	/**
	 * Import the files
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return 		string	JSON encoded text
	 * @since 		3.0
	 */
	public function display($tpl = null) {
		if (JRequest::getVar('importsession', true)) {
			// Process the data
			$this->get('ProcessData');

			// Empty the message stack
			$app = JFactory::getApplication();
			$app->set('_messageQueue', array());

			// Collect the results
			$result = array();

			// Set the view mode
			if (JRequest::getBool('csvipreview', false)) {
				$result['view'] = 'preview';
				$result['headers'] = JRequest::getVar('headers_preview');
				$result['output'] = JRequest::getVar('data_preview');

				if (empty($results['headers']) && empty($result['output'])) {
					$result['process'] = false;
					$csvilog = JRequest::getVar('csvilog');
					$result['url'] = JURI::root().'administrator/index.php?option='.JRequest::getVar('option').'&view=import&task=finished&run_id='.$csvilog->getId();

					// Clean the session, nothing to import
					$this->get('CleanSession');
				}
				else $result['process'] = true;
			}
			else {
				$result['view'] = '';
				// Get the number of records processed
				$result['records'] = JRequest::getInt('recordsprocessed');
				if ($result['records'] == 0) {
					$result['process'] = false;
					$result['url'] = JURI::root().'administrator/index.php?option='.JRequest::getVar('option').'&view=import&task=finished&run_id='.JRequest::getInt('run_id');
				}
				else {
					$result['process'] = true;
				}
			}
		}
		else {
			$csvilog = JRequest::getVar('csvilog');

			// Collect the results
			$result = array();
			$result['process'] = false;
			$result['url'] = JURI::root().'administrator/index.php?option='.JRequest::getVar('option').'&view=import&task=finished&run_id='.JRequest::getInt('run_id');

			// Clean the session, nothing to import
			$this->get('CleanSession');
		}

		// Output the results
		echo json_encode($result);
	}
}
?>