<?php
/**
 * Install page
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @todo
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<div id="logocsvi">
	<?php echo JHtml::_('image', JURI::root().'/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_logo.png', 'CSVI VirtueMart'); ?>
</div>
<div id="installcsvi">

    <div id="versions">
		<div id="oldversionbox">
			<?php
				if ($this->selectversion == 'current') echo JText::_('COM_CSVIVIRTUEMART_NONEW_VERSION');
				else echo JText::sprintf('COM_CSVIVIRTUEMART_FOUND_VERSION', $this->selectversion);
			?>
		</div>
		<div id="newversionbox">
			<?php echo JText::sprintf('COM_CSVIVIRTUEMART_NEW_VERSION', $this->newversion); ?>
		</div>
	</div>

  <div id="rightbox">

	<div id="options">
		<div>
			<?php
				foreach ($this->installoptions as $installoption) {
					if ($installoption->value == 'availablefields') $checked = 'checked="checked"';
					else $checked = '';
					?>
					<input type="checkbox" name="installoptions[]" value="<?php echo $installoption->value; ?>" id="<?php echo $installoption->value; ?>" <?php echo $checked; ?> /><?php echo $installoption->text; ?>
					<?php
				}
			?>
			<br />
			<input type="checkbox" name="removeoldtables" value="1" id="removeoldtables" /><?php echo JText::_('COM_CSVIVIRTUEMART_REMOVEOLDTABLES_LABEL'); ?>
		</div>
	</div>



	<div id="progress">
		<div id="steps">
			<?php if ($this->selectversion != 'current') { ?>
					<div id="update">
						<a onclick="updateVersion('<?php echo str_ireplace('+', '', $this->selectversion); ?>'); return false;" href="#"><?php echo JText::_('COM_CSVIVIRTUEMART_UPGRADE_CSVIVIRTUEMART'); ?></a>
					</div>
					<div id="updatedesc">
						<?php echo JText::_('COM_CSVIVIRTUEMART_UPGRADE_CSVIVIRTUEMART_DESC'); ?>
					</div>
			<?php } ?>
			<div id="install">
				<a onclick="updateVersion('current'); return false;" href="#"><?php echo JText::_('COM_CSVIVIRTUEMART_INSTALL_CSVIVIRTUEMART'); ?></a>
			</div>
			<div id="installdesc">
				<?php echo JText::_('COM_CSVIVIRTUEMART_INSTALL_CSVIVIRTUEMART_DESC'); ?>
			</div>
			<div id="spinner"></div>
			<div id="installrunning"></div>
		</div>
	</div>

   </div>


</div>




<script type="text/javascript">
function updateVersion(version) {
	jQuery('#update,#updatedesc,#install,#installdesc').hide();
	jQuery('#finished').remove();
	jQuery('#installrunning').html('');
	jQuery('#spinner').html("<img src='<?php echo JURI::root(); ?>/administrator/components/com_csvivirtuemart/assets/images/csvivirtuemart_ajax-loading.gif' />");
	var tasks = 'upgrade';
	if (jQuery('#availablefields').is(':checked')) tasks = tasks + '.availablefields';
	if (jQuery('#sampletemplates').is(':checked')) tasks = tasks + '.sampletemplates';
	if (jQuery('#removeoldtables').is(':checked')) removeold = '1';
	else removeold = '0';
	executeTask(version, tasks);
}

function executeTask(version, tasks) {
	jQuery.ajax({
		async: false,
		url: 'index.php',
		dataType: 'json',
		data: 'option=com_csvivirtuemart&view=install&task=upgrade&format=json&version='+version+'&tasks='+tasks+'&removeoldtables='+removeold,
		success: function(data) {
			if(typeof(data.results.error) !== 'undefined') {
				for (var i = 0; i < data.results.error.length; i++) {
					jQuery('#installrunning').append(data.results.error[i]+"<br />");
				}
				jQuery('#update,#updatedesc,#install,#installdesc').show();
			}

			for (var i = 0; i < data.results.messages.length; i++) {
				jQuery('#installrunning').append(data.results.messages[i]+"<br />");
			}

			// Check if more tasks need to be performed
			if (data.tasks !== "") {
				// Execute tasks
				executeTask(version, data.tasks);
			}
			else {
				jQuery('#spinner').remove();
				jQuery('#progress').prepend('<div id="finished"><?php echo JText::_('COM_CSVIVIRTUEMART_INSTALL_FINISHED'); ?></div>');
			}

		},
		failure: function(data) {
			jQuery('#spinner').html(data.responseText+"<br />");
			jQuery('#spinner').append('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_UPDATING_VERSION'); ?>');
		},
		error: function(data) {
			jQuery('#spinner').html(data.responseText+"<br />");
			jQuery('#spinner').append('<?php echo JText::_('COM_CSVIVIRTUEMART_ERROR_UPDATING_VERSION'); ?>');
		}
	});
}
</script>