<?php
/**
 * Log reader to read a log file and show it in a popup screen
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Log
 * @author	 	Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: logreader.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
if (empty($this->logdetails)) echo '<span class="error">'.sprintf(JText::_('COM_CSVIVIRTUEMART_NO_LOG_FOUND'), $this->logfile).'</span>';
else {
?>
<table class="adminlist">
	<thead>
		<tr>
			<th colspan="2"><?php echo JText::_('COM_CSVIVIRTUEMART_DETAILS'); ?></th>
		</tr>
	</thead>
	<tfoot>
	</tfoot>
	<tbody>
		<tr>
			<td><?php echo JText::_('COM_CSVIVIRTUEMART_DATE'); ?></td>
			<td><?php echo $this->logdetails['date']; ?></td>
		</tr>
		<tr>
			<td><?php echo JText::_('COM_CSVIVIRTUEMART_SOFTWARE'); ?></td>
			<td><?php echo $this->logdetails['joomla']; ?></td>
		</tr>
	</tbody>
</table>
<table class="adminlist">
	<thead>
		<tr>
			<?php foreach ($this->logdetails['fields'] as $title) { ?>
				<th><?php echo JText::_('COM_CSVIVIRTUEMART_'.strtoupper(trim($title))); ?></th>
			<?php } ?>
		</tr>
	</thead>
	<tfoot>
		<tr><td colspan="<?php echo count($this->logdetails['fields']); ?>"><?php echo sprintf(JText::_('COM_CSVIVIRTUEMART_LOG_LINES'), count($this->logdetails['entries'])); ?></td></tr>
	</tfoot>
	<tbody>
		<?php foreach ($this->logdetails['entries'] as $entry) { ?>
			<tr>
				<?php foreach ($entry as $value) { ?>
					<td><?php echo $value; ?></td>
				<?php } ?>
			</tr>
		<?php } ?>
	</tbody>
</table>
<?php } ?>
