<?php
/**
 * Details for a log entry
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Log
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: default.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );
?>
<form action="index.php" method="post" name="adminForm">
	<table class="adminlist">
		<thead>
		<tr>
			<th colspan="2"><?php echo JText::_('COM_CSVIVIRTUEMART_LOG_DETAILS'); ?></th>
		</tr>
		</thead>
		<tbody>
		<tr>
			<td><?php echo JText::_('COM_CSVIVIRTUEMART_TEMPLATE_TYPE'); ?></td><td><?php echo JText::_('COM_CSVIVIRTUEMART_'.strtoupper($this->logresult['action_type'])); ?></td>
		</tr>
		<tr>
			<td><?php echo JText::_('COM_CSVIVIRTUEMART_FILE_NAME'); ?></td><td><?php echo $this->logresult['file_name']; ?></td>
		</tr>
		<tr>
			<td><?php echo JText::_('COM_CSVIVIRTUEMART_RECORDS_PROCESSED'); ?></td><td><?php echo $this->logresult['total_records']; ?></td>
		</tr>
		<tr>
			<td>
				<?php echo JText::_('COM_CSVIVIRTUEMART_DEBUG_LOG'); ?></td><td><div><?php echo $this->logresult['debug']; ?></div>
				<?php
					if (!empty($this->logresult['debugview'])) {
						echo '<div>'.$this->logresult['debugview'].'</div>'; 
					}
				?>
			</td>
		</tr>
		</tbody>
	</table>
	<table id="loglines" class="adminlist">
		<thead>
		<tr>
			<th colspan="3"><?php echo JText::_('COM_CSVIVIRTUEMART_LOG_STATISTICS'); ?></th>
		</tr>
		</thead>
		<tbody>
			<?php
			if (empty($this->logresult['result'])) { ?>
				<tr><td><?php echo JText::_('COM_CSVIVIRTUEMART_NO_DETAILS_FOUND'); ?></td></tr>
			<?php }
			else { 
				foreach ($this->logresult['result'] as $result => $log) { ?>
					<tr>
						<td align="center">
							<?php echo $log->total_result; ?>
						</td>
						<td>
							<?php echo $log->result; ?>
						</td>
						<td>
							<?php echo JText::_('COM_CSVIVIRTUEMART_'.strtoupper($log->status)); ?>
						</td>
					</tr>
				<?php } ?> 
			</tbody>
		</table>
		<!--  Add some filters -->
		<div id="filterbox">
			<?php echo JText::_('COM_CSVIVIRTUEMART_LOGDETAILS_FILTER'); ?>
			<?php echo $this->list['actions']; ?>
			<?php echo $this->list['results']; ?>
			<input type="submit" onclick="this.form.submit();" value="<?php echo JText::_('COM_CSVIVIRTUEMART_LOGDETAILS_GO'); ?>" />
			<input type="submit" onclick="jQuery('#filter_action, #filter_result').val('');" value="<?php echo JText::_('COM_CSVIVIRTUEMART_LOGDETAILS_RESET'); ?>" />
			<div class="resultscounter"><?php echo $this->pagination->getResultsCounter(); ?></div>
		</div>
		<table id="loglines" class="adminlist">
			<thead>
			<tr>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'COM_CSVIVIRTUEMART_LOG_LINE', 'd.line', $this->list['filter_order_Dir'], $this->list['filter_order'] ); ?>
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'COM_CSVIVIRTUEMART_LOG_ACTION', 'd.status', $this->list['filter_order_Dir'], $this->list['filter_order'] ); ?>
				</th>
				<th class="title">
					<?php echo JHTML::_('grid.sort', 'COM_CSVIVIRTUEMART_LOG_RESULT', 'd.result', $this->list['filter_order_Dir'], $this->list['filter_order'] ); ?>
				</th>
				<th class="title">
				<?php echo JText::_('COM_CSVIVIRTUEMART_LOG_MESSAGE'); ?>
				</th>
			</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="4"><?php echo $this->pagination->getListFooter(); ?></td>
				</tr>
			</tfoot>
			<tbody>
			<?php
			if ($this->logmessage) {
				foreach ($this->logmessage as $key => $log) { ?>
					<tr>
						<td>
							<?php echo $log->line; ?>
						</td>
						<td>
							<?php echo JText::_('COM_CSVIVIRTUEMART_'.strtoupper($log->status)); ?>
						</td>
						<td>
							<?php echo JText::_('COM_CSVIVIRTUEMART_'.strtoupper($log->result)); ?>
						</td>
						<td>
							<?php echo nl2br($log->description); ?>
						</td>
					</tr>
					<?php
				}
			}
			?>
			</tbody>
		<?php } ?>
	</table>
	<input type="hidden" name="option" value="com_csvivirtuemart" />
	<input type="hidden" id="view" name="view" value="logdetails" />
	<input type="hidden" name="task" value="logdetails" />
	<input type="hidden" name="run_id" value="<?php echo JRequest::getInt('run_id'); ?>" />
	<input type="hidden" name="filter_order" value="<?php echo $this->list['filter_order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $this->list['filter_order_Dir']; ?>" />
</form>
<script type="text/javascript">
	UpdateRowClass('loglines');
	
	function submitbutton(task) {
		if (task == 'cancel') {
			jQuery('#view').val('log');
		}
		submitform(task);
	}
</script>
