<?php
/**
 * Log view
 *
 * The logger needs to record several messages. These are:
 * - Successful imported records
 * - Failed imported records
 * - Status messages
 * - Warning messages
 *
 * @package 	CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.html.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Log View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewLogdetails extends JView {
	
	/**
	* Log view display method
	* @return void
	*/
	function display($tpl = null) {
		$mainframe = Jfactory::getApplication();
		$option	= JRequest::getCmd('option');
		
		// Load the filters
		$list['filter_order']		= $mainframe->getUserStateFromRequest($option.'.filter_order',		'filter_order',		'',	'cmd');
		$list['filter_order_Dir']	= $mainframe->getUserStateFromRequest($option.'.filter_order_Dir',	'filter_order_Dir',	'',	'word');
		
		// Get data from the model
		$pagination = $this->get('Pagination');
		
		// Get the data to display
		$this->logmessage = $this->get('Data');
		$this->logresult = $this->get('Stats', 'log');
		
		// Set the actions
		$actions = $this->get('Actions');
		$showall = JHTML::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_SELECT_ACTION'), 'value', 'text');
		array_unshift($actions, $showall);
		$list['actions'] = JHtml::_('select.genericlist', $actions, 'filter_action',  '', 'value', 'text', JRequest::getVar('filter_action'), false, true);
		$results = $this->get('Results');
		$showall = JHTML::_('select.option', '', JText::_('COM_CSVIVIRTUEMART_SELECT_RESULT'), 'value', 'text');
		array_unshift($results, $showall);
		$list['results'] = JHtml::_('select.genericlist', $results, 'filter_result',  '', 'value', 'text', JRequest::getVar('filter_result'), false, true);
		
		// Assign the data to pass
		$this->assignRef('list', $list);
		$this->assignRef('pagination', $pagination);
		
		// Add toolbar
		JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_LOG_DETAILS'), 'csvivirtuemart_logdetails_48');
		JToolBarHelper::custom( 'cancel', 'csvivirtuemart_cancel_32', 'csvivirtuemart_cancel_32', JText::_('COM_CSVIVIRTUEMART_BACK'), false);
		
		// Display it all
		parent::display($tpl);
	}
}
?>
