<?php
/**
 * Maintenance view
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.html.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Maintenance View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewMaintenance extends JView {
	
	/**
	 * Display the maintenance screen 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		public
	 * @param 		string	$tpl	the template to use
	 * @return 
	 * @since 		3.0
	 */
	function display($tpl = null) {
		$document = JFactory::getDocument();
		$document->addScript(JURI::root().'administrator/components/com_csvivirtuemart/assets/js/jquery.alphanumeric.js');
		$app = JFactory::getApplication();
		$app->setUserState('com_csvivirtuemart.global.form', false);
		
		// Load the results
		$settings_model = new CsvivirtuemartModelSettings();
		if ($settings_model->getSetting('log_store', 1)) {
			$logresult = $this->get('Stats', 'log');
			$logmessage = $this->get('StatsMessage', 'log');
			$this->assignRef('logmessage', $logmessage);
		}
		else $logresult = false;
		$this->assignRef('logresult', $logresult);
		
		$this->assignRef('sizeproductname', $this->get('SizeProductName'));
		
		// Show the toolbar
		JToolBarHelper::title(JText::_('COM_CSVIVIRTUEMART_MAINTENANCE'), 'csvivirtuemart_maintenance_48');
		if ($this->getLayout() != 'log') {
			JToolBarHelper::custom('cronline', 'csvivirtuemart_cron_32', 'csvivirtuemart_cron_32', JText::_('COM_CSVIVIRTUEMART_CRONLINE'), false);
			JToolBarHelper::custom('maintenance', 'csvivirtuemart_continue_32.png', 'csvivirtuemart_continue_32.png', JText::_('COM_CSVIVIRTUEMART_CONTINUE'), false);
			JToolBarHelper::help('maintenance.html', true);
		}
		else if ($settings_model->getSetting('log_store', 1)) {
			JToolBarHelper::custom('logdetails', 'csvivirtuemart_logdetails_32', 'csvivirtuemart_logdetails_32', JText::_('COM_CSVIVIRTUEMART_LOG_DETAILS'), false);
		}
		
		// Display it all
		parent::display($tpl);
	}
}
?>
