<?php
/**
 * Maintenance view
 *
 * @package		CSVIVirtueMart
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: view.json.php 1892 2012-02-11 11:01:09Z RolandD $
 */

defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

jimport( 'joomla.application.component.view' );

/**
 * Maintenance View
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartViewMaintenance extends JView {

	/**
	 * Handle the JSON calls for maintenance
	 *
	 * @copyright
	 * @author 		RolandD
	 * @todo
	 * @see
	 * @access 		public
	 * @param
	 * @return
	 * @since 		3.3
	 */
	function display($tpl = null) {
		$task = strtolower(JRequest::getWord('task'));
		switch ($task) {
			case 'icecatindex':
			case 'updateavailablefields':
				JToolBarHelper::custom('cancelimport', 'csvivirtuemart_cancel_32', 'csvivirtuemart_cancel_32', JText::_('COM_CSVIVIRTUEMART_CANCEL'), false);
				// Display it all
				parent::display($tpl);
				break;
			case 'icecatsingle':
				$this->get('IcecatSingle');
				$result['view'] = '';
				// Get the number of records processed
				$result['records'] = JRequest::getInt('linesprocessed');
				if (JRequest::getBool('finished')) {
					$result['process'] = false;
					$result['url'] = JURI::root().'administrator/index.php?option='.JRequest::getVar('option').'&view=maintenance&run_id='.JRequest::getInt('run_id', 0);
				}
				else {
					$result['process'] = true;
				}
				// Output the results
				echo json_encode($result);
				break;
			case 'updateavailablefieldssingle':
				$continue = $this->get('AvailableFieldsSingle', 'availablefields');
				$result['view'] = '';
				// Get the number of records processed
				$result['table'] = JRequest::getCmd('updatetable');
				if (!$continue) {
					$result['process'] = false;
					$result['url'] = JURI::root().'administrator/index.php?option='.JRequest::getVar('option').'&view=maintenance&run_id='.JRequest::getInt('run_id', 0);

					// Store the log results
					$this->get('finishProcess');
				}
				else {
					$result['process'] = true;
				}
				// Output the results
				echo json_encode($result);
				break;
		}
	}
}
?>
