<?php
/**
 * Export front-end
 *
 * @package 	CSVIVirtueMart
 * @subpackage 	Export
 * @author 		Roland Dalmulder
 * @link 		http://www.csvimproved.com
 * @copyright 	Copyright (C) 2006 - 2012 RolandD Cyber Produksi
 * @license 	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 * @version 	$Id: export.php 1892 2012-02-11 11:01:09Z RolandD $
 */
 
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * Main processor for front-end export
 *
 * @package CSVIVirtueMart
 */
class CsvivirtuemartModelExport extends JModel {
	
	/**
	 * Prepare for export 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo
	 * @see 
	 * @access 		public
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	public function getPrepareExport() {
		// Load the basics
		$db = JFactory::getDBO();
		$option = JRequest::getVar('option');
		$exportfile_model = $this->_getModel('exportfile');
		
		// Load the backend language file
		$lang = JFactory::getLanguage();
		$lang->load('com_csvivirtuemart', JPATH_ADMINISTRATOR);
		
		// Load the template
		$template_model = $this->_getModel('templates');
		$data = $template_model->getTemplate();
		
		// Re-order the replacement fields
		if (array_key_exists('_selected_name', $data['replacement_export_fields'])) {
			$fields = array();
			$replacetext = 0;
			$replaceregex = 0;
			foreach ($data['replacement_export_fields']['_selected_name'] as $rkey => $name) {
				if ($data['replacement_export_fields']['_replace_type'][$rkey] == 1) {
					$data['replacement_fields'][$name]['findregex'][$replaceregex] = $data['replacement_export_fields']['_old_value'][$rkey];
					$data['replacement_fields'][$name]['replaceregex'][$replaceregex] = $data['replacement_export_fields']['_new_value'][$rkey];
					$replaceregex++;
				}
				else {
					$data['replacement_fields'][$name]['findtext'][$replacetext] = $data['replacement_export_fields']['_old_value'][$rkey];
					$data['replacement_fields'][$name]['replacetext'][$replacetext] = $data['replacement_export_fields']['_new_value'][$rkey];
					$replacetext++;
				}
			}
		}
		
		$template = new CsviTemplate($data);
		$template->setValue('exportto', 'general', 'tofront');
		JRequest::setVar('template', $template);
		
		// Set the export type
		JRequest::setVar('export_type', $data['export_type']);
		
		// Initiate the log
		$csvilog = new CsviLog();
		
		// Create a new Import ID in the logger
		$csvilog->setId();
		
		// Set to collect debug info
		$csvilog->setDebug($template->getValue('collect_debug_info', 'general'));
		
		// Set some log info
		$csvilog->SetAction('export');
		$csvilog->SetActionType(JRequest::getCmd('export_type'), JRequest::getVar('template_name'));
		
		// Add the logger to the registry
		JRequest::setVar('csvilog', $csvilog);
		
		// Load the fields to export
		$exportfields = $exportfile_model->getExportFields();
		if (!empty($exportfields)) {
			JRequest::setVar('export.fields', $exportfields);
			
			// Allow big SQL selects
			$db->setQuery("SET OPTION SQL_BIG_SELECTS=1");
			$db->query();
			
			// Get the filename for the export file
			JRequest::setVar('export.filename', $exportfile_model->exportFilename());
			
			// Check if tab delimiter needs to be used
			if (strtolower($template->getValue('field_delimiter', 'general')) == 't') $template->setValue('field_delimiter', 'general', "\t");
			
			// See if we need to get an XML/HTML class
			$export_format = $template->getValue('export_file', 'general');
			if ($export_format == 'xml' || $export_format == 'html') {
				$exportclass = $exportfile_model->getExportClass();
				if ($exportclass) JRequest::setVar('export.class', $exportclass);
				else {
					$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_EXPORT_CLASS'));
					JRequest::setVar('logcount', array('export' => 0));
					return false;
				}
			}
			
			// Return all is good
			return true;
		}
		else {
			$csvilog->AddStats('incorrect', JText::_('COM_CSVIVIRTUEMART_NO_EXPORT_FIELDS'));
			JRequest::setVar('logcount', array('export' => 0));
			return false;
		}
	}
	
	/**
	 * Create a proxy for including other models 
	 * 
	 * @copyright 
	 * @author 		RolandD
	 * @todo 
	 * @see 
	 * @access 		private
	 * @param 
	 * @return 
	 * @since 		3.0
	 */
	private function _getModel($model) {
		return $this->getInstance($model, 'CsvivirtuemartModel'); 
	}
}
?>