<?php
/**
 * @package AkeebaBackup
 * @copyright Copyright (c)2006-2011 Nicholas K. Dionysopoulos
 * @license GNU General Public License version 3, or later
 * @version $Id$
 * @since 3.0
 */

// Protect from unauthorized access
defined('_JEXEC') or die('Restricted Access');

// Load framework base classes
jimport('joomla.application.component.controller');

/**
 * Integrated restoration
 */
class AkeebaControllerRestore extends JController
{
	public function  __construct($config = array()) {
		parent::__construct($config);
		if(AKEEBA_JVERSION=='16')
		{
			// Access check, Joomla! 1.6 style.
			$user = JFactory::getUser();
			if (!$user->authorise('akeeba.download', 'com_akeeba')) {
				$this->setRedirect('index.php?option=com_akeeba');
				return JError::raiseWarning(403, JText::_('JERROR_ALERTNOAUTHOR'));
				$this->redirect();
			}
		} else {
			// Custom ACL for Joomla! 1.5
			$aclModel = JModel::getInstance('Acl','AkeebaModel');
			if(!$aclModel->authorizeUser('configure')) {
				$this->setRedirect('index.php?option=com_akeeba');
				return JError::raiseWarning(403, JText::_('Access Forbidden'));
				$this->redirect();
			}
		}
		$base_path = JPATH_COMPONENT_ADMINISTRATOR.DS.'plugins';
		$model_path = $base_path.DS.'models';
		$view_path = $base_path.DS.'views';
		$this->addModelPath($model_path);
		$this->addViewPath($view_path);
	}

	function display()
	{
		$model =& $this->getModel('Restore','AkeebaModel');
		$message = $model->validateRequest();
		if( $message !== true )
		{
			$this->setRedirect('index.php?option=com_akeeba&view=buadmin', $message, 'error');
			$this->redirect();
			return;
		}
		
		parent::display();
	}
	
	function start()
	{
		$model =& $this->getModel('Restore','AkeebaModel');
		$message = $model->validateRequest();
		if( $message !== true )
		{
			$this->setRedirect('index.php?option=com_akeeba&view=buadmin', $message, 'error');
			$this->redirect();
			return;
		}
		
		$status = $model->createRestorationINI();
		if( $status === false )
		{
			$this->setRedirect('index.php?option=com_akeeba&view=buadmin', JText::_('RESTORE_ERROR_CANT_WRITE'), 'error');
			$this->redirect();
			return;
		}
		
		parent::display();
	}
	
	function ajax()
	{
		$ajax = JRequest::getCmd('ajax');
		$model = $this->getModel('Restore','AkeebaModel');
		$model->setState('ajax', $ajax);
		
		$ret = $model->doAjax();
		
		@ob_end_clean();
		echo '###'.json_encode($ret).'###';
		flush();
		JFactory::getApplication()->close();
	}
}